/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.discovery;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Function;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.discovery.WeldClassFileInfo;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.weld.resources.spi.ClassFileInfo;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.util.cache.ComputingCache;
import org.jboss.weld.util.cache.ComputingCacheBuilder;
import org.jboss.weld.util.collections.ImmutableSet;

public class WeldClassFileServices
implements ClassFileServices {
    private CompositeIndex index;
    private ComputingCache<DotName, Set<String>> annotationClassAnnotationsCache;
    private final ClassLoader moduleClassLoader;

    public WeldClassFileServices(CompositeIndex index, ClassLoader moduleClassLoader) {
        if (index == null) {
            throw WeldLogger.ROOT_LOGGER.cannotUseAtRuntime(ClassFileServices.class.getSimpleName());
        }
        this.moduleClassLoader = moduleClassLoader;
        this.index = index;
        this.annotationClassAnnotationsCache = ComputingCacheBuilder.newBuilder().build((Function)new AnnotationClassAnnotationLoader());
    }

    public ClassFileInfo getClassFileInfo(String className) {
        return new WeldClassFileInfo(className, this.index, this.annotationClassAnnotationsCache, this.moduleClassLoader);
    }

    public void cleanupAfterBoot() {
        if (this.annotationClassAnnotationsCache != null) {
            this.annotationClassAnnotationsCache.clear();
            this.annotationClassAnnotationsCache = null;
        }
        this.index = null;
    }

    public void cleanup() {
        this.cleanupAfterBoot();
    }

    private class AnnotationClassAnnotationLoader
    implements Function<DotName, Set<String>> {
        private AnnotationClassAnnotationLoader() {
        }

        @Override
        public Set<String> apply(DotName name) {
            ClassInfo annotationClassInfo = WeldClassFileServices.this.index.getClassByName(name);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (annotationClassInfo != null) {
                for (DotName annotationName : annotationClassInfo.annotationsMap().keySet()) {
                    builder.add((Object)annotationName.toString());
                }
            } else {
                try {
                    Class<?> annotationClass = WeldClassFileServices.this.moduleClassLoader.loadClass(name.toString());
                    for (Annotation annotation : annotationClass.getDeclaredAnnotations()) {
                        builder.add((Object)annotation.annotationType().getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    WeldLogger.DEPLOYMENT_LOGGER.unableToLoadAnnotation(name.toString());
                }
            }
            return builder.build();
        }
    }
}

