/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.spi.ComponentInterceptorSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.ejb.spi.InterceptorBindings;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.resources.ClassTransformer;

public class WeldInterceptorBindingsService
implements Service {
    private final Consumer<InterceptorBindings> interceptorBindingsConsumer;
    private final Supplier<WeldBootstrapService> weldContainerSupplier;
    private final String beanArchiveId;
    private final String ejbName;
    private final Class<?> componentClass;
    private final ComponentInterceptorSupport interceptorSupport;
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"WeldInterceptorBindingsService"});

    public WeldInterceptorBindingsService(Consumer<InterceptorBindings> interceptorBindingsConsumer, Supplier<WeldBootstrapService> weldContainerSupplier, String beanArchiveId, String ejbName, Class<?> componentClass, ComponentInterceptorSupport componentInterceptorSupport) {
        this.interceptorBindingsConsumer = interceptorBindingsConsumer;
        this.weldContainerSupplier = weldContainerSupplier;
        this.beanArchiveId = beanArchiveId;
        this.ejbName = ejbName;
        this.componentClass = componentClass;
        this.interceptorSupport = componentInterceptorSupport;
    }

    public void start(StartContext startContext) throws StartException {
        BeanManagerImpl beanManager = this.weldContainerSupplier.get().getBeanManager(this.beanArchiveId);
        this.interceptorBindingsConsumer.accept(this.getInterceptorBindings(this.ejbName, beanManager));
    }

    public void stop(StopContext stopContext) {
        this.interceptorBindingsConsumer.accept(null);
    }

    private InterceptorBindings getInterceptorBindings(String ejbName, BeanManagerImpl manager) {
        InterceptorBindings retVal = null;
        if (ejbName != null) {
            retVal = this.interceptorSupport.getInterceptorBindings(ejbName, (WeldManager)manager);
        } else {
            InterceptionModel model;
            SlimAnnotatedType type = (SlimAnnotatedType)manager.createAnnotatedType(this.componentClass);
            if (!manager.getInterceptorModelRegistry().containsKey(type)) {
                EnhancedAnnotatedType enhancedType = ((ClassTransformer)manager.getServices().get(ClassTransformer.class)).getEnhancedAnnotatedType(type);
                InterceptionModelInitializer.of((BeanManagerImpl)manager, (EnhancedAnnotatedType)enhancedType, null).init();
            }
            if ((model = (InterceptionModel)manager.getInterceptorModelRegistry().get(type)) != null) {
                retVal = new InterceptorBindingsAdapter((InterceptionModel)manager.getInterceptorModelRegistry().get(type));
            }
        }
        return retVal != null ? retVal : NullInterceptorBindings.INSTANCE;
    }

    private static final class NullInterceptorBindings
    implements InterceptorBindings {
        private static final InterceptorBindings INSTANCE = new NullInterceptorBindings();

        private NullInterceptorBindings() {
        }

        public Collection<Interceptor<?>> getAllInterceptors() {
            return Collections.emptyList();
        }

        public List<Interceptor<?>> getMethodInterceptors(InterceptionType interceptionType, Method method) {
            return Collections.emptyList();
        }

        public List<Interceptor<?>> getLifecycleInterceptors(InterceptionType interceptionType) {
            return Collections.emptyList();
        }
    }
}

