/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpUnknownFilterType;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.engine.Receiver;
import org.junit.Assert;
import org.junit.Test;

public class AmqpReceiverWithFiltersTest
extends AmqpClientTestSupport {
    @Test(timeout=60000L)
    public void testUnsupportedFiltersAreNotListedAsSupported() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Receiver receiver) {
                Source source;
                Map filters;
                if (receiver.getRemoteSource() == null) {
                    this.markAsInvalid("Link opened with null source.");
                }
                if (org.apache.activemq.transport.amqp.AmqpSupport.findFilter((Map)(filters = (source = (Source)receiver.getRemoteSource()).getFilter()), (Object[])AmqpUnknownFilterType.UNKNOWN_FILTER_IDS) != null) {
                    this.markAsInvalid("Broker should not return unsupported filter on attach.");
                }
            }
        });
        HashMap<Symbol, AmqpUnknownFilterType> filters = new HashMap<Symbol, AmqpUnknownFilterType>();
        filters.put(AmqpUnknownFilterType.UNKNOWN_FILTER_NAME, AmqpUnknownFilterType.UNKNOWN_FILTER);
        Source source = new Source();
        source.setAddress(this.getQueueName());
        source.setFilter(filters);
        source.setDurable(TerminusDurability.NONE);
        source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        session.createReceiver(source);
        AmqpReceiverWithFiltersTest.assertEquals((long)1L, (long)this.server.getTotalConsumerCount());
        connection.getStateInspector().assertValid();
        connection.close();
    }

    @Test(timeout=60000L)
    public void testSupportedFiltersAreListedAsSupported() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            public void inspectOpenedResource(Receiver receiver) {
                Source source;
                Map filters;
                if (receiver.getRemoteSource() == null) {
                    this.markAsInvalid("Link opened with null source.");
                }
                if (org.apache.activemq.transport.amqp.AmqpSupport.findFilter((Map)(filters = (source = (Source)receiver.getRemoteSource()).getFilter()), (Object[])AmqpSupport.JMS_SELECTOR_FILTER_IDS) == null) {
                    this.markAsInvalid("Broker should return selector filter on attach.");
                }
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        session.createReceiver(this.getQueueName(), "color = red");
        connection.getStateInspector().assertValid();
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testReceivedUnsignedFilter() throws Exception {
        int NUM_MESSAGES = 100;
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = client.connect();){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(this.getQueueName());
            for (int i = 0; i < 101; ++i) {
                AmqpMessage message = new AmqpMessage();
                message.setText("Test-Message");
                message.setApplicationProperty("myNewID", (Object)new UnsignedInteger(i));
                sender.send(message);
            }
            AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "myNewID < 50");
            ArrayList<AmqpMessage> messages = new ArrayList<AmqpMessage>(100);
            receiver.flow(204);
            for (int i = 0; i < 50; ++i) {
                AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
                Assert.assertNotNull((Object)message);
                this.instanceLog.debug((Object)("Read message: " + message.getApplicationProperty("myNewID")));
                AmqpReceiverWithFiltersTest.assertNotNull((Object)message);
                messages.add(message);
            }
            Assert.assertNull((Object)receiver.receiveNoWait());
        }
    }
}

