/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorMessageFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.junit.Assert;
import org.junit.Test;

public class MirrorControllerBasicTest
extends ActiveMQTestBase {
    ActiveMQServer server;

    public void setUp() throws Exception {
        super.setUp();
        Configuration configuration = this.createDefaultNettyConfig();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)true));
        this.server.start();
    }

    @Test
    public void testSend() throws Exception {
        int i;
        ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:61616");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(1);
        Queue queue = session.createQueue("myQueue");
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)queue);
        for (i = 0; i < 10; ++i) {
            producer.send((Message)session.createTextMessage("hello"));
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertNotNull((Object)consumer.receive(1000L));
        }
        connection.close();
    }

    @Test
    public void testDirectSend() throws Exception {
        this.server.addAddressInfo(new AddressInfo("test").addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(new QueueConfiguration("test").setAddress("test").setRoutingType(RoutingType.ANYCAST));
        org.apache.activemq.artemis.api.core.Message message = AMQPMirrorMessageFactory.createMessage((String)"test", (SimpleString)SimpleString.toSimpleString((String)"ad1"), (SimpleString)SimpleString.toSimpleString((String)"qu1"), (Object)"test", (String)"someUID", (Object)"body-test");
        AMQPMirrorControllerSource.route((ActiveMQServer)this.server, (org.apache.activemq.artemis.api.core.Message)message);
        AmqpClient client = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = client.connect();
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver("test");
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        AmqpValue value = (AmqpValue)amqpMessage.getWrappedMessage().getBody();
        Assert.assertEquals((Object)"body-test", (Object)((String)value.getValue()));
        Assert.assertEquals((Object)"ad1", (Object)amqpMessage.getMessageAnnotation(AMQPMirrorControllerSource.ADDRESS.toString()));
        Assert.assertEquals((Object)"qu1", (Object)amqpMessage.getMessageAnnotation(AMQPMirrorControllerSource.QUEUE.toString()));
        Assert.assertEquals((Object)"someUID", (Object)amqpMessage.getMessageAnnotation(AMQPMirrorControllerSource.BROKER_ID.toString()));
        Assert.assertEquals((Object)"test", (Object)amqpMessage.getMessageAnnotation(AMQPMirrorControllerSource.EVENT_TYPE.toString()));
        connection.close();
    }
}

