/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.failover.MultipleServerFailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReplicatedMultipleServerFailoverTest
extends MultipleServerFailoverTestBase {
    @Parameterized.Parameter
    public MultipleServerFailoverTestBase.HAType haType;

    @Parameterized.Parameters(name="ha={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({MultipleServerFailoverTestBase.HAType.SharedNothingReplication}, {MultipleServerFailoverTestBase.HAType.PluggableQuorumReplication});
    }

    @Test
    public void testStartLiveFirst() throws Exception {
        for (TestableServer liveServer : this.liveServers) {
            liveServer.start();
        }
        for (TestableServer backupServer : this.backupServers) {
            backupServer.start();
        }
        ReplicatedMultipleServerFailoverTest.waitForTopology((ActiveMQServer)((TestableServer)this.liveServers.get(0)).getServer(), (int)this.liveServers.size(), (int)this.backupServers.size());
        this.sendCrashReceive();
    }

    @Test
    public void testStartBackupFirst() throws Exception {
        for (TestableServer backupServer : this.backupServers) {
            backupServer.start();
        }
        for (TestableServer liveServer : this.liveServers) {
            liveServer.start();
        }
        ReplicatedMultipleServerFailoverTest.waitForTopology((ActiveMQServer)((TestableServer)this.liveServers.get(0)).getServer(), (int)this.liveServers.size(), (int)this.liveServers.size());
        this.sendCrashReceive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCrashReceive() throws Exception {
        ServerLocator[] locators = new ServerLocator[this.liveServers.size()];
        try {
            int i;
            int i2;
            for (int i3 = 0; i3 < locators.length; ++i3) {
                locators[i3] = this.getServerLocator(i3);
            }
            ClientSessionFactory[] factories = new ClientSessionFactory[this.liveServers.size()];
            for (int i4 = 0; i4 < factories.length; ++i4) {
                factories[i4] = this.createSessionFactory(locators[i4]);
            }
            ClientSession[] sessions = new ClientSession[this.liveServers.size()];
            for (i2 = 0; i2 < factories.length; ++i2) {
                sessions[i2] = this.createSession(factories[i2], true, true);
                sessions[i2].createQueue(new QueueConfiguration(ADDRESS));
            }
            for (i2 = 0; i2 < this.liveServers.size(); ++i2) {
                this.waitForBindings(((TestableServer)this.liveServers.get(i2)).getServer(), ADDRESS.toString(), true, 1, 0, 2000L);
                this.waitForBindings(((TestableServer)this.liveServers.get(i2)).getServer(), ADDRESS.toString(), false, 1, 0, 2000L);
            }
            ClientProducer producer = sessions[0].createProducer(ADDRESS);
            for (int i5 = 0; i5 < this.liveServers.size() * 100; ++i5) {
                ClientMessage message = sessions[0].createMessage(true);
                this.setBody(i5, message);
                message.putIntProperty("counter", i5);
                producer.send((Message)message);
            }
            producer.close();
            for (TestableServer liveServer : this.liveServers) {
                this.waitForDistribution(ADDRESS, liveServer.getServer(), 100);
            }
            for (TestableServer liveServer : this.liveServers) {
                liveServer.crash(new ClientSession[0]);
            }
            ClientConsumer[] consumers = new ClientConsumer[this.liveServers.size()];
            for (i = 0; i < factories.length; ++i) {
                consumers[i] = sessions[i].createConsumer(ADDRESS);
                sessions[i].start();
            }
            for (i = 0; i < 100; ++i) {
                for (ClientConsumer consumer : consumers) {
                    ClientMessage message = consumer.receive(1000L);
                    ReplicatedMultipleServerFailoverTest.assertNotNull((String)("expecting durable msg " + i), (Object)message);
                    message.acknowledge();
                }
            }
        }
        finally {
            for (ServerLocator locator : locators) {
                if (locator == null) continue;
                try {
                    locator.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int getLiveServerCount() {
        return 2;
    }

    @Override
    public int getBackupServerCount() {
        return 2;
    }

    @Override
    public boolean isNetty() {
        return true;
    }

    @Override
    public MultipleServerFailoverTestBase.HAType haType() {
        return this.haType;
    }

    @Override
    public String getNodeGroupName() {
        return "nodeGroup";
    }
}

