/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.jboss.logging.Logger;
import org.junit.Before;
import org.junit.Test;

public class FloodServerTest
extends ActiveMQTestBase {
    private static final Logger log = Logger.getLogger(FloodServerTest.class);
    private ActiveMQServer server;
    private final String topicName = "my-topic";

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultNettyConfig();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        this.server.start();
    }

    @Test
    public void testFoo() {
    }

    public void _testFlood() throws Exception {
        int i;
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactory((String)"tcp://127.0.0.1:61616?retryInterval=1000&retryIntervalMultiplier=1.0&reconnectAttempts=-1&callTimeout=30000&clientFailureCheckPeriod=1000&maxRetryInterval=1000&blockOnDurableSend=false&blockOnAcknowledge=false", (String)"cf");
        int numProducers = 20;
        int numConsumers = 20;
        int numMessages = 10000;
        ProducerThread[] producers = new ProducerThread[20];
        for (int i2 = 0; i2 < 20; ++i2) {
            producers[i2] = new ProducerThread((ConnectionFactory)cf, 10000);
        }
        ConsumerThread[] consumers = new ConsumerThread[20];
        for (i = 0; i < 20; ++i) {
            consumers[i] = new ConsumerThread((ConnectionFactory)cf, 10000);
        }
        for (i = 0; i < 20; ++i) {
            consumers[i].start();
        }
        for (i = 0; i < 20; ++i) {
            producers[i].start();
        }
        for (i = 0; i < 20; ++i) {
            consumers[i].join();
        }
        for (i = 0; i < 20; ++i) {
            producers[i].join();
        }
    }

    class ConsumerThread
    extends Thread {
        private final Connection connection;
        private final Session session;
        private final MessageConsumer consumer;
        private final int numMessages;

        ConsumerThread(ConnectionFactory cf, int numMessages) throws Exception {
            this.connection = cf.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 1);
            this.consumer = this.session.createConsumer((Destination)ActiveMQJMSClient.createTopic((String)"my-topic"));
            this.numMessages = numMessages;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.numMessages; ++i) {
                    Message msg = this.consumer.receive();
                    if (msg != null) continue;
                    log.error((Object)"message is null");
                    break;
                }
                this.connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class ProducerThread
    extends Thread {
        private final Connection connection;
        private final Session session;
        private final MessageProducer producer;
        private final int numMessages;

        ProducerThread(ConnectionFactory cf, int numMessages) throws Exception {
            this.connection = cf.createConnection();
            this.session = this.connection.createSession(false, 1);
            this.producer = this.session.createProducer((Destination)ActiveMQJMSClient.createTopic((String)"my-topic"));
            this.producer.setDeliveryMode(1);
            this.numMessages = numMessages;
        }

        @Override
        public void run() {
            try {
                byte[] bytes = new byte[1000];
                BytesMessage message = this.session.createBytesMessage();
                message.writeBytes(bytes);
                for (int i = 0; i < this.numMessages; ++i) {
                    this.producer.send((Message)message);
                }
                this.connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

