/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsumerDelayDispatchTest
extends JMSTestBase {
    private SimpleString queueName = SimpleString.toSimpleString((String)"jms.consumer.delay.queue");
    private SimpleString normalQueueName = SimpleString.toSimpleString((String)"jms.noraml.queue");
    private static final long DELAY_BEFORE_DISPATCH = 10000L;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server.createQueue(new QueueConfiguration(this.queueName).setRoutingType(RoutingType.ANYCAST).setExclusive(Boolean.valueOf(true)).setConsumersBeforeDispatch(Integer.valueOf(2)).setDelayBeforeDispatch(Long.valueOf(10000L)));
        this.server.createQueue(new QueueConfiguration(this.normalQueueName).setRoutingType(RoutingType.ANYCAST).setExclusive(Boolean.valueOf(true)));
    }

    protected ConnectionFactory getCF() throws Exception {
        return this.cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoDelayOnDefault() throws Exception {
        this.sendMessage(this.normalQueueName);
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            connection.start();
            Queue queue = session.createQueue(this.normalQueueName.toString());
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            Assert.assertNotNull((Object)this.receive(consumer1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelayBeforeDispatch() throws Exception {
        this.sendMessage(this.queueName);
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            connection.start();
            Queue queue = session.createQueue(this.queueName.toString());
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            Assert.assertNull((Object)this.receive(consumer1));
            Thread.sleep(10000L);
            Assert.assertNotNull((Object)this.receive(consumer1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumersBeforeDispatch() throws Exception {
        this.sendMessage(this.queueName);
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            connection.start();
            Queue queue = session.createQueue(this.queueName.toString());
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            Assert.assertNull((Object)this.receive(consumer1));
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            Assert.assertNotNull((Object)this.receive(consumer1, consumer2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContinueAndResetConsumer() throws Exception {
        this.sendMessage(this.queueName);
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            connection.start();
            Queue queue = session.createQueue(this.queueName.toString());
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            Assert.assertNull((Object)this.receive(consumer1));
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            Assert.assertNotNull((Object)this.receive(consumer1, consumer2));
            consumer2.close();
            this.sendMessage(this.queueName);
            Assert.assertNotNull((Object)this.receive(consumer1));
            consumer1.close();
            this.sendMessage(this.queueName);
            MessageConsumer consumer3 = session.createConsumer((Destination)queue);
            Assert.assertNull((Object)this.receive(consumer3));
            MessageConsumer consumer4 = session.createConsumer((Destination)queue);
            Assert.assertNotNull((Object)this.receive(consumer3, consumer4));
            consumer3.close();
            consumer4.close();
            this.sendMessage(this.queueName);
            MessageConsumer consumer5 = session.createConsumer((Destination)queue);
            Assert.assertNull((Object)this.receive(consumer5));
            Thread.sleep(10000L);
            Assert.assertNotNull((Object)this.receive(consumer5));
        }
    }

    private Message receive(MessageConsumer consumer1) throws JMSException {
        return consumer1.receive(1000L);
    }

    private Message receive(MessageConsumer consumer1, MessageConsumer consumer2) throws JMSException {
        Message receivedMessage = this.receive(consumer1);
        if (receivedMessage == null) {
            receivedMessage = this.receive(consumer2);
        }
        return receivedMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(SimpleString queue) throws Exception {
        ConnectionFactory fact = this.getCF();
        try (Connection connection = fact.createConnection();){
            Session session = connection.createSession(false, 2);
            connection.start();
            Queue destination = session.createQueue(queue.toString());
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage();
            message.setText("Message");
            producer.send((Message)message);
        }
    }
}

