/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.management;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.ConsumerEventSource;
import org.apache.activemq.advisory.ProducerEventSource;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OpenWireManagementTest
extends OpenWireTestBase {
    private ActiveMQServerControl serverControl;
    private SimpleString queueName1 = new SimpleString("queue1");
    private SimpleString queueName2 = new SimpleString("queue2");
    private SimpleString queueName3 = new SimpleString("queue3");
    private ConnectionFactory factory;
    private boolean useDefault;
    private boolean supportAdvisory;
    private boolean suppressJmx;

    @Parameterized.Parameters(name="useDefault={0},supportAdvisory={1},suppressJmx={2}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({true, false, false}, {false, true, false}, {false, true, true}, {false, false, false}, {false, false, true});
    }

    public OpenWireManagementTest(boolean useDefault, boolean supportAdvisory, boolean suppressJmx) {
        this.useDefault = useDefault;
        this.supportAdvisory = supportAdvisory;
        this.suppressJmx = suppressJmx;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.serverControl = (ActiveMQServerControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getActiveMQServerObjectName(), ActiveMQServerControl.class, this.mbeanServer);
        this.factory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        serverConfig.setJMXManagementEnabled(true);
        if (this.useDefault) {
            return;
        }
        Set acceptorConfigs = serverConfig.getAcceptorConfigurations();
        for (TransportConfiguration tconfig : acceptorConfigs) {
            if (!"netty".equals(tconfig.getName())) continue;
            Map params = tconfig.getExtraParams();
            params.put("supportAdvisory", this.supportAdvisory);
            params.put("suppressInternalManagementObjects", this.suppressJmx);
        }
    }

    @Test
    public void testHiddenInternalAddress() throws Exception {
        this.server.createQueue(new QueueConfiguration(this.queueName1).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(true)));
        this.server.createQueue(new QueueConfiguration(this.queueName2).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(true)));
        this.server.createQueue(new QueueConfiguration(this.queueName3).setRoutingType(RoutingType.ANYCAST).setAutoCreateAddress(Boolean.valueOf(true)));
        String[] addresses = this.serverControl.getAddressNames();
        OpenWireManagementTest.assertEquals((long)4L, (long)addresses.length);
        for (String addr : addresses) {
            OpenWireManagementTest.assertFalse((boolean)addr.startsWith("ActiveMQ.Advisory."));
        }
        try (Connection connection = this.factory.createConnection();){
            String addr;
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(this.queueName1.toString());
            ConsumerEventSource consumerEventSource = new ConsumerEventSource(connection, (Destination)destination);
            consumerEventSource.setConsumerListener(consumerEvent -> {});
            consumerEventSource.start();
            ProducerEventSource producerEventSource = new ProducerEventSource(connection, (Destination)destination);
            producerEventSource.setProducerListener(producerEvent -> {});
            producerEventSource.start();
            addresses = this.serverControl.getAddressNames();
            boolean hasInternalAddress = false;
            String[] stringArray = addresses;
            int n = stringArray.length;
            for (int i = 0; i < n && !(hasInternalAddress = (addr = stringArray[i]).startsWith("ActiveMQ.Advisory.")); ++i) {
            }
            OpenWireManagementTest.assertEquals((Object)(!this.useDefault && this.supportAdvisory && !this.suppressJmx ? 1 : 0), (Object)hasInternalAddress);
            consumerEventSource.stop();
            producerEventSource.stop();
        }
    }

    @Test
    public void testHiddenInternalQueue() throws Exception {
        this.server.createQueue(new QueueConfiguration(this.queueName1).setRoutingType(RoutingType.ANYCAST));
        String[] queues = this.serverControl.getQueueNames();
        OpenWireManagementTest.assertEquals((long)1L, (long)queues.length);
        for (String queue : queues) {
            OpenWireManagementTest.assertFalse((boolean)this.checkQueueFromInternalAddress(queue));
        }
        try (Connection connection = this.factory.createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(this.queueName1.toString());
            session.createProducer((Destination)destination);
            queues = this.serverControl.getQueueNames();
            boolean hasInternal = false;
            String targetQueue = null;
            for (String queue : queues) {
                hasInternal = this.checkQueueFromInternalAddress(queue);
                if (!hasInternal) continue;
                targetQueue = queue;
                break;
            }
            OpenWireManagementTest.assertEquals((String)("targetQueue: " + targetQueue), (Object)(!this.useDefault && this.supportAdvisory && !this.suppressJmx ? 1 : 0), (Object)hasInternal);
        }
    }

    private boolean checkQueueFromInternalAddress(String queue) throws JMSException, ActiveMQException {
        try (Connection coreConn = this.coreCf.createConnection();){
            ActiveMQSession session = (ActiveMQSession)coreConn.createSession();
            ClientSession coreSession = session.getCoreSession();
            ClientSession.QueueQuery query = coreSession.queueQuery(new SimpleString(queue));
            OpenWireManagementTest.assertTrue((String)("Queue doesn't exist: " + queue), (boolean)query.isExists());
            SimpleString qAddr = query.getAddress();
            boolean bl = qAddr.toString().startsWith("ActiveMQ.Advisory.");
            return bl;
        }
    }
}

