/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.paging.cursor.impl.PageSubscriptionImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class PagingReceiveTest
extends ActiveMQTestBase {
    private static final SimpleString ADDRESS = new SimpleString("catalog-service.price.change.bm");
    private ActiveMQServer server;
    private ServerLocator locator;
    private int numMsgs = 100;

    protected boolean isNetty() {
        return false;
    }

    @Test
    public void testReceive() throws Exception {
        ClientMessage message = this.receiveMessage();
        PagingReceiveTest.assertNotNull((String)"Message not found.", (Object)message);
    }

    @Test
    public void testReceiveThenCheckCounter() throws Exception {
        Queue queue = this.server.locateQueue(ADDRESS);
        PagingReceiveTest.assertEquals((long)this.numMsgs, (long)queue.getMessagesAdded());
        this.receiveAllMessages();
        queue.getPageSubscription().scheduleCleanupCheck();
        Wait.assertEquals((int)0, ((PageSubscriptionImpl)queue.getPageSubscription()).getScheduledCleanupCount()::get);
        PagingReceiveTest.assertEquals((long)this.numMsgs, (long)queue.getMessagesAdded());
    }

    @Test
    public void testReceiveTx() throws Exception {
        this.receiveAllMessagesTxAndPageCheckPendingTx();
    }

    private void receiveAllMessagesTxAndPageCheckPendingTx() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(null, null, false, true, false, false, 0);
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        for (int i = 0; i < this.numMsgs; ++i) {
            ClientMessage message = consumer.receive(2000L);
            PagingReceiveTest.assertNotNull((Object)message);
            message.acknowledge();
        }
        PagingStore store = this.server.getPagingManager().getPageStore(ADDRESS);
        long qid = this.server.locateQueue(ADDRESS).getID();
        PageSubscription pageSub = store.getCursorProvider().getSubscription(qid);
        long pageNr = store.getCurrentWritingPage();
        Wait.assertTrue(() -> ((PageSubscriptionImpl)pageSub).getPageInfo(pageNr).getPendingTx() > 0);
        PageSubscriptionImpl.PageCursorInfo info = ((PageSubscriptionImpl)pageSub).getPageInfo(pageNr);
        session.commit();
        session.close();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.internalCreateServer();
        this.server.addAddressInfo(new AddressInfo(ADDRESS, RoutingType.ANYCAST));
        Queue queue = this.server.createQueue(new QueueConfiguration(ADDRESS).setRoutingType(RoutingType.ANYCAST));
        queue.getPageSubscription().getPagingStore().startPaging();
        for (int i = 0; i < 10; ++i) {
            queue.getPageSubscription().getPagingStore().forceAnotherPage();
        }
        this.locator.setBlockOnNonDurableSend(false).setBlockOnAcknowledge(false);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(null, null, false, true, true, false, 0);
        ClientProducer prod = session.createProducer(ADDRESS);
        for (int i = 0; i < this.numMsgs; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.putIntProperty("key", i);
            prod.send((Message)msg);
            if (i <= 0 || i % 10 != 0) continue;
            session.commit();
        }
        session.close();
        this.locator.close();
        this.server.stop();
        this.server = this.internalCreateServer();
    }

    private ActiveMQServer internalCreateServer() throws Exception {
        ActiveMQServer server = this.newActiveMQServer();
        server.start();
        this.waitForServerToStart(server);
        this.locator = this.createFactory(this.isNetty());
        return server;
    }

    private void receiveAllMessages() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(null, null, false, true, true, false, 0);
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        for (int i = 0; i < this.numMsgs; ++i) {
            ClientMessage message = consumer.receive(2000L);
            PagingReceiveTest.assertNotNull((Object)message);
            message.acknowledge();
        }
        session.commit();
        session.close();
    }

    private ClientMessage receiveMessage() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(null, null, false, true, true, false, 0);
        session.start();
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        ClientMessage message = consumer.receive(1000L);
        session.commit();
        if (message != null) {
            message.acknowledge();
        }
        consumer.close();
        session.close();
        return message;
    }

    private ActiveMQServer newActiveMQServer() throws Exception {
        ActiveMQServer server = this.createServer(true, this.isNetty());
        AddressSettings settings = new AddressSettings().setMaxSizeBytes(0x4000000L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setMaxRedeliveryDelay(3600000L).setRedeliveryMultiplier(2.0).setRedeliveryDelay(500L);
        server.getAddressSettingsRepository().addMatch("#", (Object)settings);
        return server;
    }
}

