/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.plugin;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.tests.integration.plugin.MethodCalledVerifier;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionV12;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class StompPluginTest
extends StompTestBase {
    public static final String CLIENT_ID = "myclientid";
    private StompClientConnectionV12 conn;
    private final Map<String, AtomicInteger> methodCalls = new ConcurrentHashMap<String, AtomicInteger>();
    private final MethodCalledVerifier verifier = new MethodCalledVerifier(this.methodCalls);
    private final AtomicBoolean stompBeforeCreateSession = new AtomicBoolean();
    private final AtomicBoolean stompBeforeRemoveSession = new AtomicBoolean();

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"ws+v12.stomp"}, {"tcp+v12.stomp"});
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.conn = (StompClientConnectionV12)StompClientConnectionFactory.createClientConnection("1.2", this.hostname, 61613);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            boolean connected;
            boolean bl = connected = this.conn != null && this.conn.isConnected();
            if (connected) {
                this.conn.disconnect();
            }
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        ActiveMQServer server = super.createServer();
        server.getConfiguration().setAddressQueueScanPeriod(100L);
        server.registerBrokerPlugin((ActiveMQServerBasePlugin)this.verifier);
        server.registerBrokerPlugin((ActiveMQServerBasePlugin)new ActiveMQServerPlugin(){

            public void beforeCreateSession(String name, String username, int minLargeMessageSize, RemotingConnection connection, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean xa, String defaultAddress, SessionCallback callback, boolean autoCreateQueues, OperationContext context, Map<SimpleString, RoutingType> prefixes) throws ActiveMQException {
                if (connection instanceof StompConnection) {
                    StompPluginTest.this.stompBeforeCreateSession.set(true);
                }
            }

            public void beforeCloseSession(ServerSession session, boolean failed) throws ActiveMQException {
                if (session.getRemotingConnection() instanceof StompConnection) {
                    StompPluginTest.this.stompBeforeRemoveSession.set(true);
                }
            }
        });
        return server;
    }

    @Test
    public void testSendAndReceive() throws Exception {
        URI uri = new URI(this.scheme + "://localhost:61613");
        StompClientConnection newConn = StompClientConnectionFactory.createClientConnection(uri);
        newConn.connect(this.defUser, this.defPass);
        StompPluginTest.subscribe(newConn, "a-sub");
        StompPluginTest.send(newConn, StompPluginTest.getQueuePrefix() + StompPluginTest.getQueueName(), "text/plain", "Hello World 1!");
        ClientStompFrame frame = newConn.receiveFrame();
        System.out.println("received " + frame);
        Assert.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        this.verifier.validatePluginMethodsAtLeast(1, "messageAcknowledged", "beforeSend", "afterSend", "beforeMessageRoute", "afterMessageRoute", "beforeDeliver", "afterDeliver");
        StompPluginTest.unsubscribe(newConn, "a-sub");
        newConn.disconnect();
        this.verifier.validatePluginMethodsEquals(0, "messageExpired", "beforeDeployBridge", "afterDeployBridge", "beforeRemoveBinding", "afterRemoveBinding");
        this.verifier.validatePluginMethodsAtLeast(1, "afterCreateConnection", "afterDestroyConnection", "beforeCreateSession", "afterCreateSession", "beforeCloseSession", "afterCloseSession", "beforeCreateConsumer", "afterCreateConsumer", "beforeCloseConsumer", "afterCloseConsumer", "beforeCreateQueue", "afterCreateQueue", "messageAcknowledged", "beforeSend", "afterSend", "beforeMessageRoute", "afterMessageRoute", "beforeDeliver", "afterDeliver", "beforeAddAddress", "afterAddAddress", "beforeAddBinding", "afterAddBinding");
    }

    @Test
    public void testStompAutoCreateAddress() throws Exception {
        URI uri = new URI(this.scheme + "://localhost:61613");
        StompClientConnection newConn = StompClientConnectionFactory.createClientConnection(uri);
        newConn.connect(this.defUser, this.defPass);
        StompPluginTest.subscribeQueue(newConn, "a-sub", "autoCreated");
        StompPluginTest.unsubscribe(newConn, "a-sub");
        newConn.disconnect();
        this.verifier.validatePluginMethodsAtLeast(1, "beforeAddAddress", "afterAddAddress", "beforeRemoveAddress", "afterRemoveAddress");
    }

    @Test
    public void testConnect() throws Exception {
        URI uri = new URI(this.scheme + "://localhost:61613");
        StompClientConnection newConn = StompClientConnectionFactory.createClientConnection(uri);
        newConn.connect(this.defUser, this.defPass);
        StompPluginTest.assertTrue((boolean)this.stompBeforeCreateSession.get());
        newConn.disconnect();
        Thread.sleep(500L);
        StompPluginTest.assertTrue((boolean)this.stompBeforeRemoveSession.get());
    }
}

