/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.LiveOnlyPolicyConfiguration;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.ClusterConnectionImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.utils.RetryRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ScaleDownRemoveSFTest
extends ClusterTestBase {
    @Rule
    public RetryRule retryRule = new RetryRule(3);

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ScaleDownConfiguration scaleDownConfiguration = new ScaleDownConfiguration();
        this.setupLiveServer(0, this.isFileStorage(), this.isNetty(), true);
        this.setupLiveServer(1, this.isFileStorage(), this.isNetty(), true);
        LiveOnlyPolicyConfiguration haPolicyConfiguration0 = (LiveOnlyPolicyConfiguration)this.servers[0].getConfiguration().getHAPolicyConfiguration();
        haPolicyConfiguration0.setScaleDownConfiguration(scaleDownConfiguration);
        LiveOnlyPolicyConfiguration haPolicyConfiguration1 = (LiveOnlyPolicyConfiguration)this.servers[1].getConfiguration().getHAPolicyConfiguration();
        haPolicyConfiguration1.setScaleDownConfiguration(new ScaleDownConfiguration());
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        haPolicyConfiguration0.getScaleDownConfiguration().getConnectors().addAll(((ClusterConnectionConfiguration)this.servers[0].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors());
        haPolicyConfiguration1.getScaleDownConfiguration().getConnectors().addAll(((ClusterConnectionConfiguration)this.servers[1].getConfiguration().getClusterConfigurations().iterator().next()).getStaticConnectors());
        this.servers[0].getConfiguration().getAddressesSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        this.servers[1].getConfiguration().getAddressesSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        this.startServers(0, 1);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected boolean isNetty() {
        return true;
    }

    @Test
    public void testScaleDownCheckSF() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        this.createQueue(0, "testAddress", "testQueue1", null, true);
        this.createQueue(1, "testAddress", "testQueue1", null, true);
        this.send(0, "testAddress", 2, true, null);
        this.addConsumer(1, 0, "testQueue1", null, false);
        ClientMessage clientMessage = this.consumers[1].getConsumer().receive(5000L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        this.consumers[1].getSession().commit();
        Assert.assertEquals((long)1L, (long)this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(new SimpleString("testQueue1"))).getQueue()));
        ClusterConnectionImpl clusterconn1 = (ClusterConnectionImpl)this.servers[1].getClusterManager().getClusterConnection("cluster0");
        SimpleString sfQueueName = clusterconn1.getSfQueueName(this.servers[0].getNodeID().toString());
        this.instanceLog.debug((Object)("[sf queue on server 1]: " + sfQueueName));
        Assert.assertTrue((boolean)this.servers[1].queueQuery(sfQueueName).isExists());
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        clientMessage = this.consumers[0].getConsumer().receive(10000L);
        Assert.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receiveImmediate();
        Assert.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        Assert.assertFalse((boolean)this.servers[1].queueQuery(sfQueueName).isExists());
        Assert.assertFalse((boolean)this.servers[1].addressQuery(sfQueueName).isExists());
    }
}

