/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.server.impl;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileLockTest
extends ActiveMQTestBase {
    @Before
    public void setUp() throws Exception {
        super.setUp();
        File file = new File(this.getTestDir());
        file.mkdirs();
    }

    @Test
    public void testSetNodeID() throws Exception {
        FileLockNodeManager underTest = new FileLockNodeManager(this.getTestDirfile(), false);
        ReplicationPrimaryPolicyConfiguration replicationPrimaryPolicyConfiguration = ReplicationPrimaryPolicyConfiguration.withDefault();
        String seed = "";
        for (int i = 0; i < 20; ++i) {
            replicationPrimaryPolicyConfiguration.setCoordinationId(seed);
            if (replicationPrimaryPolicyConfiguration.getCoordinationId() != null) {
                underTest.setNodeID(replicationPrimaryPolicyConfiguration.getCoordinationId());
            }
            seed = seed + String.valueOf(i);
        }
        replicationPrimaryPolicyConfiguration.setCoordinationId("somme-dash-and-odd");
        if (replicationPrimaryPolicyConfiguration.getCoordinationId() != null) {
            underTest.setNodeID(replicationPrimaryPolicyConfiguration.getCoordinationId());
        }
    }

    @Test
    public void testNodeManagerStartPersistence() throws Exception {
        File managerDirectory = this.getTestDirfile();
        FileLockNodeManager manager = new FileLockNodeManager(managerDirectory, false);
        manager.start();
        Set files = Arrays.stream(managerDirectory.listFiles(pathname -> pathname.isFile())).collect(Collectors.toSet());
        Set expectedFileNames = Arrays.stream(new String[]{"server.lock", "serverlock.1", "serverlock.2"}).collect(Collectors.toSet());
        Assert.assertEquals(expectedFileNames, files.stream().map(File::getName).collect(Collectors.toSet()));
        File nodeIdFile = files.stream().filter(file -> file.getName().equals("server.lock")).findFirst().get();
        byte[] encodedNodeId = manager.getUUID().asBytes();
        try (FileChannel serverLock = FileChannel.open(nodeIdFile.toPath(), StandardOpenOption.READ);){
            Assert.assertEquals((long)16L, (long)encodedNodeId.length);
            Assert.assertEquals((long)19L, (long)serverLock.size());
            ByteBuffer readNodeId = ByteBuffer.allocate(16);
            serverLock.read(readNodeId, 3L);
            readNodeId.flip();
            Assert.assertArrayEquals((byte[])encodedNodeId, (byte[])readNodeId.array());
        }
        Assert.assertEquals((long)-1L, (long)manager.getNodeActivationSequence());
        Assert.assertEquals((long)-1L, (long)manager.readNodeActivationSequence());
        Assert.assertEquals((long)3L, (long)managerDirectory.listFiles(pathname -> pathname.isFile()).length);
        manager.stop();
    }

    @Test
    public void testReplicateBackupNodeManagerStartPersistence() throws Exception {
        File managerDirectory = this.getTestDirfile();
        FileLockNodeManager manager = new FileLockNodeManager(managerDirectory, true);
        manager.start();
        Set files = Arrays.stream(managerDirectory.listFiles(pathname -> pathname.isFile())).collect(Collectors.toSet());
        Assert.assertTrue((boolean)files.isEmpty());
        Assert.assertNull((Object)manager.getNodeId());
        Assert.assertNull((Object)manager.getUUID());
        Assert.assertEquals((long)-1L, (long)manager.getNodeActivationSequence());
        Assert.assertEquals((long)-1L, (long)manager.readNodeActivationSequence());
        Assert.assertEquals((long)0L, (long)managerDirectory.listFiles(pathname -> pathname.isFile()).length);
        manager.stop();
    }

    @Test
    public void testReplicatedStopBackupPersistence() throws Exception {
        FileLockNodeManager manager = new FileLockNodeManager(this.getTestDirfile(), false);
        manager.start();
        Assert.assertNotNull((Object)manager.getUUID());
        manager.writeNodeActivationSequence(1L);
        long nodeActivationSequence = manager.getNodeActivationSequence();
        Assert.assertEquals((long)1L, (long)nodeActivationSequence);
        manager.stop();
        FileLockNodeManager replicatedManager = new FileLockNodeManager(this.getTestDirfile(), true);
        replicatedManager.start();
        Assert.assertNull((Object)replicatedManager.getUUID());
        Assert.assertEquals((long)1L, (long)replicatedManager.getNodeActivationSequence());
        UUID storedNodeId = UUIDGenerator.getInstance().generateUUID();
        replicatedManager.setNodeID(storedNodeId.toString());
        replicatedManager.setNodeActivationSequence(2L);
        replicatedManager.stopBackup();
        replicatedManager.setNodeID(UUIDGenerator.getInstance().generateStringUUID());
        replicatedManager.setNodeActivationSequence(3L);
        replicatedManager.stop();
        manager.start();
        Assert.assertEquals((Object)storedNodeId, (Object)manager.getUUID());
        Assert.assertEquals((long)2L, (long)manager.getNodeActivationSequence());
        manager.stop();
    }

    @Test
    public void testWriteNodeActivationSequence() throws Exception {
        FileLockNodeManager manager = new FileLockNodeManager(this.getTestDirfile(), false);
        manager.start();
        UUID id = manager.getUUID();
        Assert.assertNotNull((Object)manager.getUUID());
        manager.writeNodeActivationSequence(1L);
        long nodeActivationSequence = manager.getNodeActivationSequence();
        Assert.assertEquals((long)1L, (long)nodeActivationSequence);
        manager.stop();
        FileLockNodeManager otherManager = new FileLockNodeManager(this.getTestDirfile(), false);
        otherManager.start();
        Assert.assertEquals((Object)id, (Object)otherManager.getUUID());
        Assert.assertEquals((long)1L, (long)otherManager.getNodeActivationSequence());
        otherManager.stop();
    }

    @Test
    public void testNIOLock() throws Exception {
        this.doTestLock(new FileLockNodeManager(this.getTestDirfile(), false), new FileLockNodeManager(this.getTestDirfile(), false));
    }

    public void doTestLock(FileLockNodeManager lockManager1, final FileLockNodeManager lockManager2) throws Exception {
        lockManager1.start();
        lockManager2.start();
        lockManager1.startLiveNode();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    lockManager2.startLiveNode();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        FileLockTest.assertTrue((boolean)lockManager1.isLiveLocked());
        Thread.sleep(500L);
        FileLockTest.assertFalse((boolean)lockManager2.isLiveLocked());
        lockManager1.crashLiveServer();
        t.join();
        FileLockTest.assertFalse((boolean)lockManager1.isLiveLocked());
        FileLockTest.assertTrue((boolean)lockManager2.isLiveLocked());
        lockManager2.crashLiveServer();
        lockManager1.stop();
        lockManager2.stop();
    }
}

