/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.utils.AutomaticLatch;
import org.junit.Assert;
import org.junit.Test;

public class AutomaticLatchTest {
    @Test
    public void testWthPending() {
        AtomicInteger value = new AtomicInteger(0);
        AutomaticLatch latch = new AutomaticLatch(1);
        latch.afterCompletion(() -> value.incrementAndGet());
        Assert.assertEquals((long)0L, (long)value.get());
        latch.countDown();
        Assert.assertEquals((long)1L, (long)value.get());
    }

    @Test
    public void testWthoutPending() {
        AtomicInteger value = new AtomicInteger(0);
        AutomaticLatch latch = new AutomaticLatch(0);
        latch.afterCompletion(() -> value.incrementAndGet());
        Assert.assertEquals((long)1L, (long)value.get());
        latch.countUp();
        latch.countDown();
        Assert.assertEquals((long)1L, (long)value.get());
        latch.afterCompletion(() -> value.addAndGet(10));
        Assert.assertEquals((long)11L, (long)value.get());
        latch.countUp();
        latch.countDown();
        Assert.assertEquals((long)11L, (long)value.get());
    }

    @Test
    public void testMultipleCallsOrder() {
        ArrayList outcome = new ArrayList();
        AutomaticLatch latch = new AutomaticLatch(1);
        latch.afterCompletion(() -> outcome.add(0));
        latch.afterCompletion(() -> outcome.add(1));
        latch.afterCompletion(() -> outcome.add(2));
        latch.countDown();
        Assert.assertEquals((Object)0, outcome.get(0));
        Assert.assertEquals((Object)1, outcome.get(1));
        Assert.assertEquals((Object)2, outcome.get(2));
        Assert.assertEquals((long)3L, (long)outcome.size());
    }
}

