/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.util;

import java.util.HashSet;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.Assert;
import org.junit.Test;

public class UUIDGeneratorTest
extends ActiveMQTestBase {
    @Test
    public void testFromJavaUUID() throws Exception {
        java.util.UUID javaId = java.util.UUID.randomUUID();
        UUIDGenerator gen = UUIDGenerator.getInstance();
        UUID nativeId = gen.fromJavaUUID(javaId);
        UUIDGeneratorTest.assertEquals((Object)javaId.toString(), (Object)nativeId.toString());
    }

    @Test
    public void testDifferentInTightLoop() throws Exception {
        UUIDGenerator gen = UUIDGenerator.getInstance();
        int numIterations = 10000;
        HashSet<UUID> uuidSet = new HashSet<UUID>();
        for (int i = 0; i < 10000; ++i) {
            UUID nativeId = gen.generateUUID();
            uuidSet.add(nativeId);
        }
        UUIDGeneratorTest.assertEquals((String)"All there", (long)10000L, (long)uuidSet.size());
    }

    @Test
    public void testGetHardwareAddress() throws Exception {
        byte[] bytes = UUIDGenerator.getHardwareAddress();
        Assert.assertNotNull((Object)bytes);
        Assert.assertTrue((bytes.length == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testZeroPaddedBytes() throws Exception {
        Assert.assertNull((Object)UUIDGenerator.getZeroPaddedSixBytes(null));
        Assert.assertNull((Object)UUIDGenerator.getZeroPaddedSixBytes((byte[])new byte[0]));
        Assert.assertNull((Object)UUIDGenerator.getZeroPaddedSixBytes((byte[])new byte[7]));
        byte[] fiveBytes = new byte[]{1, 2, 3, 4, 5};
        byte[] zeroPaddedFiveBytes = UUIDGenerator.getZeroPaddedSixBytes((byte[])fiveBytes);
        ActiveMQTestBase.assertEqualsByteArrays((byte[])new byte[]{1, 2, 3, 4, 5, 0}, (byte[])zeroPaddedFiveBytes);
        byte[] fourBytes = new byte[]{1, 2, 3, 4};
        byte[] zeroPaddedFourBytes = UUIDGenerator.getZeroPaddedSixBytes((byte[])fourBytes);
        ActiveMQTestBase.assertEqualsByteArrays((byte[])new byte[]{1, 2, 3, 4, 0, 0}, (byte[])zeroPaddedFourBytes);
        byte[] threeBytes = new byte[]{1, 2, 3};
        byte[] zeroPaddedThreeBytes = UUIDGenerator.getZeroPaddedSixBytes((byte[])threeBytes);
        ActiveMQTestBase.assertEqualsByteArrays((byte[])new byte[]{1, 2, 3, 0, 0, 0}, (byte[])zeroPaddedThreeBytes);
    }
}

