/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import org.wildfly.clustering.ejb.infinispan.timer.ImmutableScheduleExpressionBuilder;
import org.wildfly.clustering.ejb.timer.ImmutableScheduleExpression;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum ImmutableScheduleExpressionMarshaller implements FieldSetMarshaller<ImmutableScheduleExpression, ImmutableScheduleExpressionBuilder>
{
    INSTANCE;

    private static final int START_FIELD = 0;
    private static final int END_FIELD = 1;
    private static final int YEAR_FIELD = 2;
    private static final int MONTH_FIELD = 3;
    private static final int DAY_OF_MONTH_FIELD = 4;
    private static final int DAY_OF_WEEK_FIELD = 5;
    private static final int ZONE_FIELD = 6;
    private static final int HOUR_FIELD = 7;
    private static final int MINUTE_FIELD = 8;
    private static final int SECOND_FIELD = 9;
    private static final int FIELDS = 10;
    private final ImmutableScheduleExpression defaultExpression = this.getBuilder().build();

    public ImmutableScheduleExpressionBuilder getBuilder() {
        return new ImmutableScheduleExpressionBuilder();
    }

    public int getFields() {
        return 10;
    }

    public ImmutableScheduleExpressionBuilder readField(ProtoStreamReader reader, int index, ImmutableScheduleExpressionBuilder builder) throws IOException {
        switch (index) {
            case 0: {
                return builder.start((Instant)reader.readObject(Instant.class));
            }
            case 1: {
                return builder.end((Instant)reader.readObject(Instant.class));
            }
            case 2: {
                return builder.year(reader.readString());
            }
            case 3: {
                return builder.month(reader.readString());
            }
            case 4: {
                return builder.dayOfMonth(reader.readString());
            }
            case 5: {
                return builder.dayOfWeek(reader.readString());
            }
            case 6: {
                return builder.zone((ZoneId)reader.readObject(ZoneId.class));
            }
            case 7: {
                return builder.hour(reader.readString());
            }
            case 8: {
                return builder.minute(reader.readString());
            }
            case 9: {
                return builder.second(reader.readString());
            }
        }
        return builder;
    }

    public void writeFields(ProtoStreamWriter writer, int startIndex, ImmutableScheduleExpression expression) throws IOException {
        String second;
        String minute;
        String hour;
        ZoneId zone;
        String dayOfWeek;
        String dayOfMonth;
        String month;
        String year;
        Instant end;
        Instant start = expression.getStart();
        if (!Objects.equals(start, this.defaultExpression.getStart())) {
            writer.writeObject(startIndex + 0, (Object)start);
        }
        if (!Objects.equals(end = expression.getEnd(), this.defaultExpression.getEnd())) {
            writer.writeObject(startIndex + 1, (Object)end);
        }
        if (!Objects.equals(year = expression.getYear(), this.defaultExpression.getYear())) {
            writer.writeString(startIndex + 2, year);
        }
        if (!Objects.equals(month = expression.getMonth(), this.defaultExpression.getMonth())) {
            writer.writeString(startIndex + 3, month);
        }
        if (!Objects.equals(dayOfMonth = expression.getDayOfMonth(), this.defaultExpression.getDayOfMonth())) {
            writer.writeString(startIndex + 4, dayOfMonth);
        }
        if (!Objects.equals(dayOfWeek = expression.getDayOfWeek(), this.defaultExpression.getDayOfWeek())) {
            writer.writeString(startIndex + 5, dayOfWeek);
        }
        if (!Objects.equals(zone = expression.getZone(), this.defaultExpression.getZone())) {
            writer.writeObject(startIndex + 6, (Object)zone);
        }
        if (!Objects.equals(hour = expression.getHour(), this.defaultExpression.getHour())) {
            writer.writeString(startIndex + 7, hour);
        }
        if (!Objects.equals(minute = expression.getMinute(), this.defaultExpression.getMinute())) {
            writer.writeString(startIndex + 8, minute);
        }
        if (!Objects.equals(second = expression.getSecond(), this.defaultExpression.getSecond())) {
            writer.writeString(startIndex + 9, second);
        }
    }
}

