/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.lang.reflect.Method;
import java.util.function.Predicate;

public class TimeoutDescriptor
implements Predicate<Method> {
    private final String methodName;
    private final int parameters;

    public TimeoutDescriptor(Method method) {
        this(method.getName(), method.getParameterCount());
    }

    public TimeoutDescriptor(String methodName, int parameters) {
        this.methodName = methodName;
        this.parameters = parameters;
    }

    String getMethodName() {
        return this.methodName;
    }

    int getParameters() {
        return this.parameters;
    }

    @Override
    public boolean test(Method method) {
        return method.getName().equals(this.methodName) && method.getParameterCount() == this.parameters;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimeoutDescriptor)) {
            return false;
        }
        TimeoutDescriptor descriptor = (TimeoutDescriptor)object;
        return this.methodName.equals(descriptor.methodName) && this.parameters == descriptor.parameters;
    }

    public int hashCode() {
        return this.methodName.hashCode() + this.parameters;
    }
}

