/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.time.Duration;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.ee.cache.ConcurrentManager;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.hotrod.HotRodConfiguration;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshaller;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.ConcurrentSessionManager;
import org.wildfly.clustering.web.cache.session.MarshalledValueSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionFactory;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManager;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaDataFactory;
import org.wildfly.clustering.web.hotrod.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;

public class HotRodSessionManagerFactory<S, SC, AL, LC>
implements SessionManagerFactory<SC, LC, TransactionBatch> {
    private final HotRodConfiguration configuration;
    private final Registrar<SessionExpirationListener> expirationListenerRegistrar;
    private final SessionFactory<SC, CompositeSessionMetaDataEntry<LC>, ?, LC> factory;

    public HotRodSessionManagerFactory(HotRodSessionManagerFactoryConfiguration<S, SC, AL, LC> configuration) {
        this.configuration = configuration;
        HotRodSessionMetaDataFactory metaDataFactory = new HotRodSessionMetaDataFactory(configuration);
        HotRodSessionFactory sessionFactory = new HotRodSessionFactory(configuration, metaDataFactory, this.createSessionAttributesFactory(configuration), configuration.getLocalContextFactory());
        this.factory = sessionFactory;
        this.expirationListenerRegistrar = sessionFactory;
    }

    public SessionManager<LC, TransactionBatch> createSessionManager(final SessionManagerConfiguration<SC> configuration) {
        final Duration transactionTimeout = Duration.ofMillis(this.configuration.getCache().getRemoteCacheContainer().getConfiguration().transactionTimeout());
        final Registrar<SessionExpirationListener> expirationRegistrar = this.expirationListenerRegistrar;
        AbstractHotRodSessionManagerConfiguration config = new AbstractHotRodSessionManagerConfiguration<SC>(this.configuration){

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public Registrar<SessionExpirationListener> getExpirationListenerRegistrar() {
                return expirationRegistrar;
            }

            @Override
            public Supplier<String> getIdentifierFactory() {
                return configuration.getIdentifierFactory();
            }

            @Override
            public SC getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public Duration getStopTimeout() {
                return transactionTimeout;
            }
        };
        return new ConcurrentSessionManager(new HotRodSessionManager(this.factory, config), ConcurrentManager::new);
    }

    public void close() {
        this.factory.close();
    }

    private SessionAttributesFactory<SC, ?> createSessionAttributesFactory(HotRodSessionManagerFactoryConfiguration<S, SC, AL, LC> configuration) {
        switch (configuration.getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory<S, SC, AL, LC>(new HotRodMarshalledValueSessionAttributesFactoryConfiguration(configuration));
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory<S, SC, AL, LC>(new HotRodMarshalledValueSessionAttributesFactoryConfiguration(configuration));
            }
        }
        throw new IllegalStateException();
    }

    private static class HotRodMarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, V, LC>
    extends MarshalledValueSessionAttributesFactoryConfiguration<S, SC, AL, V, LC>
    implements HotRodSessionAttributesFactoryConfiguration<S, SC, AL, V, MarshalledValue<V, ByteBufferMarshaller>> {
        private final HotRodSessionManagerFactoryConfiguration<S, SC, AL, LC> configuration;

        HotRodMarshalledValueSessionAttributesFactoryConfiguration(HotRodSessionManagerFactoryConfiguration<S, SC, AL, LC> configuration) {
            super(configuration);
            this.configuration = configuration;
        }

        public <CK, CV> RemoteCache<CK, CV> getCache() {
            return this.configuration.getCache();
        }
    }

    private static abstract class AbstractHotRodSessionManagerConfiguration<SC>
    implements HotRodSessionManagerConfiguration<SC> {
        private final HotRodConfiguration configuration;

        AbstractHotRodSessionManagerConfiguration(HotRodConfiguration configuration) {
            this.configuration = configuration;
        }

        public <CK, CV> RemoteCache<CK, CV> getCache() {
            return this.configuration.getCache();
        }
    }
}

