/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.wildfly.extension.messaging.activemq.BridgeDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BridgeAdd
extends AbstractAddStepHandler {
    public static final BridgeAdd INSTANCE = new BridgeAdd();
    static final String CALL_TIMEOUT_PROPERTY = "org.wildfly.messaging.core.bridge.call-timeout";
    static final String ROUTING_TYPE_PROPERTY = "org.wildfly.messaging.core.bridge.%s.routing-type";

    private BridgeAdd() {
        super(BridgeDefinition.ATTRIBUTES);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel());
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServiceName serviceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController service = registry.getService(serviceName = MessagingServices.getActiveMQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (service != null) {
            if (service.getState() != ServiceController.State.UP) {
                throw MessagingLogger.ROOT_LOGGER.invalidServiceState(serviceName, ServiceController.State.UP, service.getState());
            }
            String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            BridgeConfiguration bridgeConfig = BridgeAdd.createBridgeConfiguration((ExpressionResolver)context, name, model);
            ActiveMQServer server = (ActiveMQServer)ActiveMQServer.class.cast(service.getValue());
            BridgeAdd.createBridge(bridgeConfig, server);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)BridgeDefinition.CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
    }

    static BridgeConfiguration createBridgeConfiguration(ExpressionResolver expressionResolver, String name, ModelNode model) throws OperationFailedException {
        Long callTimeout;
        String queueName = BridgeDefinition.QUEUE_NAME.resolveModelAttribute(expressionResolver, model).asString();
        String forwardingAddress = BridgeDefinition.FORWARDING_ADDRESS.resolveModelAttribute(expressionResolver, model).asStringOrNull();
        String filterString = CommonAttributes.FILTER.resolveModelAttribute(expressionResolver, model).asStringOrNull();
        int minLargeMessageSize = CommonAttributes.MIN_LARGE_MESSAGE_SIZE.resolveModelAttribute(expressionResolver, model).asInt();
        long retryInterval = CommonAttributes.RETRY_INTERVAL.resolveModelAttribute(expressionResolver, model).asLong();
        double retryIntervalMultiplier = CommonAttributes.RETRY_INTERVAL_MULTIPLIER.resolveModelAttribute(expressionResolver, model).asDouble();
        long maxRetryInterval = CommonAttributes.MAX_RETRY_INTERVAL.resolveModelAttribute(expressionResolver, model).asLong();
        int initialConnectAttempts = BridgeDefinition.INITIAL_CONNECT_ATTEMPTS.resolveModelAttribute(expressionResolver, model).asInt();
        int reconnectAttempts = BridgeDefinition.RECONNECT_ATTEMPTS.resolveModelAttribute(expressionResolver, model).asInt();
        int reconnectAttemptsOnSameNode = BridgeDefinition.RECONNECT_ATTEMPTS_ON_SAME_NODE.resolveModelAttribute(expressionResolver, model).asInt();
        boolean useDuplicateDetection = BridgeDefinition.USE_DUPLICATE_DETECTION.resolveModelAttribute(expressionResolver, model).asBoolean();
        int confirmationWindowSize = CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(expressionResolver, model).asInt();
        int producerWindowSize = BridgeDefinition.PRODUCER_WINDOW_SIZE.resolveModelAttribute(expressionResolver, model).asInt();
        long clientFailureCheckPeriod = CommonAttributes.CHECK_PERIOD.resolveModelAttribute(expressionResolver, model).asLong();
        long connectionTTL = CommonAttributes.CONNECTION_TTL.resolveModelAttribute(expressionResolver, model).asLong();
        ModelNode discoveryNode = BridgeDefinition.DISCOVERY_GROUP_NAME.resolveModelAttribute(expressionResolver, model);
        String discoveryGroupName = discoveryNode.isDefined() ? discoveryNode.asString() : null;
        List<String> staticConnectors = discoveryGroupName == null ? BridgeAdd.getStaticConnectors(model) : null;
        boolean ha = CommonAttributes.HA.resolveModelAttribute(expressionResolver, model).asBoolean();
        String user = BridgeDefinition.USER.resolveModelAttribute(expressionResolver, model).asString();
        String password = BridgeDefinition.PASSWORD.resolveModelAttribute(expressionResolver, model).asString();
        String routingType = BridgeAdd.getRoutingTypeFromSystemProperty(name);
        if (routingType == null) {
            routingType = BridgeDefinition.ROUTING_TYPE.resolveModelAttribute(expressionResolver, model).asString();
        }
        if ((callTimeout = BridgeAdd.getCallTimeoutFromSystemProperty()) == null) {
            callTimeout = BridgeDefinition.CALL_TIMEOUT.resolveModelAttribute(expressionResolver, model).asLong();
        }
        BridgeConfiguration config = new BridgeConfiguration().setName(name).setQueueName(queueName).setForwardingAddress(forwardingAddress).setFilterString(filterString).setMinLargeMessageSize(minLargeMessageSize).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setRetryInterval(retryInterval).setMaxRetryInterval(maxRetryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setReconnectAttemptsOnSameNode(reconnectAttemptsOnSameNode).setUseDuplicateDetection(useDuplicateDetection).setConfirmationWindowSize(confirmationWindowSize).setProducerWindowSize(producerWindowSize).setHA(ha).setUser(user).setPassword(password).setCallTimeout(callTimeout.longValue()).setRoutingType(ComponentConfigurationRoutingType.valueOf((String)routingType));
        if (discoveryGroupName != null) {
            config.setDiscoveryGroupName(discoveryGroupName);
        } else {
            config.setStaticConnectors(staticConnectors);
        }
        ModelNode transformerClassName = CommonAttributes.TRANSFORMER_CLASS_NAME.resolveModelAttribute(expressionResolver, model);
        if (transformerClassName.isDefined()) {
            config.setTransformerConfiguration(new TransformerConfiguration(transformerClassName.asString()));
        }
        return config;
    }

    private static List<String> getStaticConnectors(ModelNode model) {
        ArrayList<String> result = new ArrayList<String>();
        for (ModelNode connector : model.require("static-connectors").asList()) {
            result.add(connector.asString());
        }
        return result;
    }

    static void createBridge(BridgeConfiguration bridgeConfig, ActiveMQServer server) throws OperationFailedException {
        BridgeAdd.checkStarted(server);
        BridgeAdd.clearIO(server);
        try {
            if (!server.deployBridge(bridgeConfig)) {
                throw MessagingLogger.ROOT_LOGGER.failedBridgeDeployment(bridgeConfig.getName());
            }
        }
        catch (RuntimeException | OperationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            BridgeAdd.blockOnIO(server);
        }
    }

    static void checkStarted(ActiveMQServer server) {
        if (!server.isStarted()) {
            throw MessagingLogger.ROOT_LOGGER.brokerNotStarted();
        }
    }

    static void clearIO(ActiveMQServer server) {
        StorageManager storageManager = server.getStorageManager();
        if (storageManager != null) {
            storageManager.clearContext();
        }
    }

    static void blockOnIO(ActiveMQServer server) {
        StorageManager storageManager = server.getStorageManager();
        if (storageManager != null && storageManager.isStarted()) {
            try {
                storageManager.waitOnOperations();
                storageManager.clearContext();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static Long getCallTimeoutFromSystemProperty() {
        String value = WildFlySecurityManager.getSystemPropertiesPrivileged().getProperty(CALL_TIMEOUT_PROPERTY);
        if (value == null) {
            return null;
        }
        return Long.parseLong(value);
    }

    private static String getRoutingTypeFromSystemProperty(String name) {
        return WildFlySecurityManager.getSystemPropertiesPrivileged().getProperty(String.format(ROUTING_TYPE_PROPERTY, name));
    }
}

