/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;

public class UnmodifiableMapExternalizer<T extends Map<Object, Object>>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final Function<Map.Entry<Object, Object>[], T> factory;

    public UnmodifiableMapExternalizer(Class<T> targetClass, Function<Map.Entry<Object, Object>[], T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T map) throws IOException {
        IndexSerializer.VARIABLE.writeInt(output, map.size());
        for (Map.Entry entry : map.entrySet()) {
            output.writeObject(entry.getKey());
            output.writeObject(entry.getValue());
        }
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Map.Entry[] entries = new Map.Entry[IndexSerializer.VARIABLE.readInt(input)];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = Map.entry(input.readObject(), input.readObject());
        }
        return (T)((Map)this.factory.apply(entries));
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

