/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.CoreManagementResourceDefinition;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;

abstract class ScopedRoleAddHandler
extends AbstractAddStepHandler {
    private static final PathAddress AUTHZ_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[]{CoreManagementResourceDefinition.PATH_ELEMENT, AccessAuthorizationResourceDefinition.PATH_ELEMENT});
    private final WritableAuthorizerConfiguration authorizerConfiguration;

    ScopedRoleAddHandler(WritableAuthorizerConfiguration authorizerConfiguration) {
        this.authorizerConfiguration = authorizerConfiguration;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathElement lastElement = address.getLastElement();
        String roleName = lastElement.getValue();
        Set standardRoles = this.authorizerConfiguration.getStandardRoles();
        for (String current : standardRoles) {
            if (!roleName.equalsIgnoreCase(current)) continue;
            throw DomainManagementLogger.ROOT_LOGGER.scopedRoleStandardName(roleName, current);
        }
        Resource readResource = context.readResourceFromRoot(AUTHZ_ADDRESS, false);
        Set hostScopedRoles = readResource.getChildrenNames("host-scoped-role");
        for (String current : hostScopedRoles) {
            if (!roleName.equalsIgnoreCase(current)) continue;
            throw DomainManagementLogger.ROOT_LOGGER.duplicateScopedRole("host-scoped-role", roleName);
        }
        Set serverGroupScopedRoles = readResource.getChildrenNames("server-group-scoped-role");
        for (String current : serverGroupScopedRoles) {
            if (!roleName.equalsIgnoreCase(current)) continue;
            throw DomainManagementLogger.ROOT_LOGGER.duplicateScopedRole("server-group-scoped-role", roleName);
        }
        super.execute(context, operation);
    }
}

