/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.domain.management.LegacyConfigurationChangeResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

final class ManagementXml_4
implements ManagementXml {
    private final Namespace namespace;
    private final ManagementXmlDelegate delegate;
    private final boolean domainConfiguration;

    ManagementXml_4(Namespace namespace, ManagementXmlDelegate delegate, boolean domainConfiguration) {
        this.namespace = namespace;
        this.delegate = delegate;
        this.domainConfiguration = domainConfiguration;
    }

    @Override
    public void parseManagement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        boolean securityRealmsCount = false;
        boolean connectionsCount = false;
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (this.domainConfiguration) {
                if (element == Element.ACCESS_CONTROL) {
                    if (this.delegate.parseAccessControl(reader, managementAddress, list)) continue;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case SECURITY_REALMS: {
                    throw DomainManagementLogger.ROOT_LOGGER.securityRealmsUnsupported();
                }
                case OUTBOUND_CONNECTIONS: {
                    throw DomainManagementLogger.ROOT_LOGGER.outboundConnectionsUnsupported();
                }
                case MANAGEMENT_INTERFACES: {
                    if (++managementInterfacesCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseManagementInterfaces(reader, managementAddress, list)) continue block8;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case AUDIT_LOG: {
                    if (this.delegate.parseAuditLog(reader, managementAddress, list)) continue block8;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case ACCESS_CONTROL: {
                    if (this.delegate.parseAccessControl(reader, managementAddress, list)) continue block8;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case CONFIGURATION_CHANGES: {
                    this.parseConfigurationChanges(reader, managementAddress, list);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }

    private void parseConfigurationChanges(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        PathAddress operationAddress = PathAddress.pathAddress((ModelNode)address);
        operationAddress = operationAddress.append(new PathElement[]{LegacyConfigurationChangeResourceDefinition.PATH});
        ModelNode add = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathAddress)operationAddress, (PathElement[])new PathElement[0]));
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_HISTORY: {
                    LegacyConfigurationChangeResourceDefinition.MAX_HISTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        list.add(add);
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

