/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.journal;

import java.io.File;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.LockAbstract;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import picocli.CommandLine;

@CommandLine.Command(name="compact", description={"Compact the journal of a non running server."})
public final class CompactJournal
extends LockAbstract {
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        try {
            FileConfiguration configuration = this.getFileConfiguration();
            CompactJournal.compactJournals((Configuration)configuration);
        }
        catch (Exception e) {
            this.treatError(e, "data", "compact");
        }
        return null;
    }

    public static void compactJournals(Configuration configuration) throws Exception {
        CompactJournal.compactJournal(configuration.getJournalLocation(), configuration.getJournalRetentionLocation(), "activemq-data", "amq", configuration.getJournalMinFiles(), configuration.getJournalPoolFiles(), configuration.getJournalFileSize(), null, 34, 36);
        System.out.println("Compactation succeeded for " + configuration.getJournalLocation().getAbsolutePath());
        CompactJournal.compactJournal(configuration.getBindingsLocation(), null, "activemq-bindings", "bindings", 2, 2, 0x100000, null, new byte[0]);
        System.out.println("Compactation succeeded for " + configuration.getBindingsLocation());
    }

    public static void compactJournal(File directory, File historyFolder, String journalPrefix, String journalSuffix, int minFiles, int poolFiles, int fileSize, IOCriticalErrorListener listener, byte ... replaceableRecords) throws Exception {
        NIOSequentialFileFactory nio = new NIOSequentialFileFactory(directory, listener, 1);
        JournalImpl journal = new JournalImpl(fileSize, minFiles, poolFiles, 0, 0, (SequentialFileFactory)nio, journalPrefix, journalSuffix, 1);
        if (historyFolder != null) {
            journal.setHistoryFolder(historyFolder, -1L, -1L);
        }
        for (byte i : replaceableRecords) {
            journal.replaceableRecord(i);
        }
        journal.setRemoveExtraFilesOnLoad(true);
        journal.start();
        journal.loadInternalOnly();
        journal.compact();
        journal.stop();
    }
}

