/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.url.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.url.UrlAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.url.internal.UrlAttributes;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class InternalUrlAttributesExtractor<REQUEST> {
    private final UrlAttributesGetter<REQUEST> getter;
    private final Function<REQUEST, String> alternateSchemeProvider;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalUrlAttributesExtractor(UrlAttributesGetter<REQUEST> getter, Function<REQUEST, String> alternateSchemeProvider, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.alternateSchemeProvider = alternateSchemeProvider;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        String urlScheme = this.getUrlScheme(request);
        String urlPath = this.getter.getUrlPath(request);
        String urlQuery = this.getter.getUrlQuery(request);
        if (this.emitStableUrlAttributes) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, UrlAttributes.URL_SCHEME, (Object)urlScheme);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, UrlAttributes.URL_PATH, (Object)urlPath);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, UrlAttributes.URL_QUERY, (Object)urlQuery);
        }
        if (this.emitOldHttpAttributes) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_SCHEME, (Object)urlScheme);
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_TARGET, (Object)InternalUrlAttributesExtractor.getTarget(urlPath, urlQuery));
        }
    }

    private String getUrlScheme(REQUEST request) {
        String urlScheme = this.alternateSchemeProvider.apply(request);
        if (urlScheme == null) {
            urlScheme = this.getter.getUrlScheme(request);
        }
        return urlScheme;
    }

    @Nullable
    private static String getTarget(@Nullable String path, @Nullable String query) {
        if (path == null && query == null) {
            return null;
        }
        return (path == null ? "" : path) + (query == null || query.isEmpty() ? "" : "?" + query);
    }
}

