/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection.finders;

import jakarta.annotation.Resource;
import java.lang.reflect.Field;
import org.jboss.ws.common.injection.finders.ReflectionUtils;
import org.jboss.ws.common.reflection.AnnotatedFieldFinder;

public final class ResourceFieldFinder
extends AnnotatedFieldFinder<Resource> {
    private final Class<?> accept;
    private final boolean include;

    public ResourceFieldFinder(Class<?> accept, boolean include) {
        super(Resource.class);
        this.accept = accept;
        this.include = include;
    }

    @Override
    public void validate(Field field) {
        super.validate(field);
        Class annotation = this.getAnnotation();
        ReflectionUtils.assertNotVoidType(field, annotation);
        ReflectionUtils.assertNotStatic(field, annotation);
        ReflectionUtils.assertNotFinal(field, annotation);
        ReflectionUtils.assertNotPrimitiveType(field, annotation);
    }

    @Override
    public boolean matches(Field field) {
        boolean matches = super.matches(field);
        if (matches && this.accept != null) {
            Class<?> fieldType = field.getType();
            boolean parameterMatch = this.accept.equals(fieldType);
            return this.include ? parameterMatch : !parameterMatch;
        }
        return matches;
    }
}

