/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.invocation;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.ws.api.handler.GenericSOAPHandler;
import org.jboss.ws.api.monitoring.Record;
import org.jboss.ws.api.monitoring.RecordGroupAssociation;
import org.jboss.ws.api.monitoring.RecordProcessor;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.monitoring.RecordFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;
import org.w3c.dom.Node;

public class RecordingServerHandler
extends GenericSOAPHandler<SOAPMessageContext> {
    protected boolean handleInbound(SOAPMessageContext ctx) {
        Endpoint endpoint = EndpointAssociation.getEndpoint();
        if (endpoint != null && this.isRecording(endpoint)) {
            Record record = RecordFactory.newRecord();
            RecordGroupAssociation.pushGroupID((String)record.getGroupID());
            record.setDate(new Date());
            HttpServletRequest httpServletRequest = (HttpServletRequest)ctx.get((Object)"jakarta.xml.ws.servlet.request");
            if (httpServletRequest != null) {
                try {
                    record.setDestinationHost(new URL(httpServletRequest.getRequestURL().toString()).getHost());
                    record.setSourceHost(httpServletRequest.getRemoteHost());
                }
                catch (Exception e) {
                    Loggers.MONITORING_LOGGER.unableToReadFromHttpServletRequest(e);
                }
            }
            record.setHeaders((Map)ctx.get((Object)"jakarta.xml.ws.http.request.headers"));
            record.setMessageType(Record.MessageType.INBOUND);
            record.setOperation((QName)ctx.get((Object)"jakarta.xml.ws.wsdl.operation"));
            boolean processEnvelope = false;
            Iterator it = endpoint.getRecordProcessors().iterator();
            while (it.hasNext() && !processEnvelope) {
                processEnvelope = ((RecordProcessor)it.next()).isProcessEnvelope();
            }
            if (processEnvelope) {
                try {
                    SOAPEnvelope soapEnv = ctx.getMessage().getSOAPPart().getEnvelope();
                    if (soapEnv != null) {
                        record.setEnvelope(DOMWriter.printNode((Node)soapEnv, true));
                    }
                }
                catch (SOAPException ex) {
                    Loggers.MONITORING_LOGGER.cannotTraceSoapMessage(ex);
                }
            }
            endpoint.processRecord(record);
        }
        return true;
    }

    protected boolean handleOutbound(SOAPMessageContext ctx) {
        Endpoint endpoint = EndpointAssociation.getEndpoint();
        if (endpoint != null && this.isRecording(endpoint)) {
            String groupID = RecordGroupAssociation.popGroupID();
            Record record = RecordFactory.newRecord(groupID);
            record.setDate(new Date());
            record.setHeaders((Map)ctx.get((Object)"jakarta.xml.ws.http.response.headers"));
            record.setMessageType(Record.MessageType.OUTBOUND);
            record.setOperation((QName)ctx.get((Object)"jakarta.xml.ws.wsdl.operation"));
            boolean processEnvelope = false;
            Iterator it = endpoint.getRecordProcessors().iterator();
            while (it.hasNext() && !processEnvelope) {
                processEnvelope = ((RecordProcessor)it.next()).isProcessEnvelope();
            }
            if (processEnvelope) {
                try {
                    SOAPEnvelope soapEnv = ctx.getMessage().getSOAPPart().getEnvelope();
                    if (soapEnv != null) {
                        record.setEnvelope(DOMWriter.printNode((Node)soapEnv, true));
                    }
                }
                catch (SOAPException ex) {
                    Loggers.MONITORING_LOGGER.cannotTraceSoapMessage(ex);
                }
            }
            endpoint.processRecord(record);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext ctx) {
        return this.handleOutbound(ctx);
    }

    private boolean isRecording(Endpoint endpoint) {
        List processors = endpoint.getRecordProcessors();
        if (processors == null || processors.isEmpty()) {
            return false;
        }
        for (RecordProcessor processor : processors) {
            if (!processor.isRecording()) continue;
            return true;
        }
        return false;
    }
}

