/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CaseParameterCorrector;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.QueueAdd;
import org.wildfly.extension.messaging.activemq.QueueControlHandler;
import org.wildfly.extension.messaging.activemq.QueueReadAttributeHandler;
import org.wildfly.extension.messaging.activemq.QueueRemove;

public class QueueDefinition
extends PersistentResourceDefinition {
    private static final String DEFAULT_ROUTING_TYPE_PROPERTY = "org.wildfly.messaging.core.queue.default.routing-type";
    public static final String DEFAULT_ROUTING_TYPE = System.getSecurityManager() == null ? System.getProperty("org.wildfly.messaging.core.queue.default.routing-type") : AccessController.doPrivileged(() -> System.getProperty(DEFAULT_ROUTING_TYPE_PROPERTY));
    public static final SimpleAttributeDefinition ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"queue-address", (ModelType)ModelType.STRING).setXmlName("address")).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ROUTING_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"routing-type", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode(RoutingType.MULTICAST.toString()))).setRequired(false)).setAllowExpression(true)).setCorrector(CaseParameterCorrector.TO_UPPER)).setValidator((ParameterValidator)EnumValidator.create(RoutingType.class, (Enum[])RoutingType.values()))).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{ADDRESS, CommonAttributes.FILTER, CommonAttributes.DURABLE, ROUTING_TYPE};
    public static final SimpleAttributeDefinition EXPIRY_ADDRESS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.EXPIRY_ADDRESS).setStorageRuntime()).build();
    public static final SimpleAttributeDefinition DEAD_LETTER_ADDRESS = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.DEAD_LETTER_ADDRESS).setStorageRuntime()).build();
    static final AttributeDefinition ID = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"id", (ModelType)ModelType.LONG).setStorageRuntime()).build();
    static final AttributeDefinition[] READONLY_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.PAUSED, CommonAttributes.TEMPORARY, ID, DEAD_LETTER_ADDRESS, EXPIRY_ADDRESS};
    static final AttributeDefinition[] METRICS = new AttributeDefinition[]{CommonAttributes.MESSAGE_COUNT, CommonAttributes.DELIVERING_COUNT, CommonAttributes.MESSAGES_ADDED, CommonAttributes.SCHEDULED_COUNT, CommonAttributes.CONSUMER_COUNT};
    private final boolean registerRuntimeOnly;

    QueueDefinition(boolean registerRuntimeOnly, PathElement path) {
        super(path, MessagingExtension.getResourceDescriptionResolver("queue"), (OperationStepHandler)(path == MessagingExtension.RUNTIME_QUEUE_PATH ? null : QueueAdd.INSTANCE), (OperationStepHandler)(path == MessagingExtension.RUNTIME_QUEUE_PATH ? null : QueueRemove.INSTANCE), path == MessagingExtension.RUNTIME_QUEUE_PATH);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public boolean isRuntime() {
        return this.getPathElement() == MessagingExtension.RUNTIME_QUEUE_PATH;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        super.registerAttributes(registry);
        for (SimpleAttributeDefinition simpleAttributeDefinition : ATTRIBUTES) {
            if (simpleAttributeDefinition.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            if (this.isRuntime()) {
                SimpleAttributeDefinition readOnlyRuntimeAttr = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)simpleAttributeDefinition).setStorageRuntime()).build();
                registry.registerReadOnlyAttribute((AttributeDefinition)readOnlyRuntimeAttr, (OperationStepHandler)QueueReadAttributeHandler.RUNTIME_INSTANCE);
                continue;
            }
            registry.registerReadOnlyAttribute((AttributeDefinition)simpleAttributeDefinition, null);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : READONLY_ATTRIBUTES) {
            registry.registerReadOnlyAttribute((AttributeDefinition)simpleAttributeDefinition, (OperationStepHandler)QueueReadAttributeHandler.INSTANCE);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : METRICS) {
            registry.registerMetric((AttributeDefinition)simpleAttributeDefinition, (OperationStepHandler)QueueReadAttributeHandler.INSTANCE);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Collections.emptyList();
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            QueueControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        if (this.isRuntime()) {
            return Collections.emptyList();
        }
        return Arrays.asList(MessagingExtension.QUEUE_ACCESS_CONSTRAINT);
    }

    static boolean forwardToRuntimeQueue(OperationContext context, ModelNode operation, OperationStepHandler handler) {
        PathAddress address = context.getCurrentAddress();
        if ("runtime-queue".equals(address.getLastElement().getKey())) {
            return false;
        }
        String queueName = address.getLastElement().getValue();
        PathAddress activeMQPathAddress = MessagingServices.getActiveMQServerPathAddress(address);
        if (context.readResourceFromRoot(activeMQPathAddress, false).hasChild(address.getLastElement())) {
            return false;
        }
        ModelNode forwardOperation = operation.clone();
        forwardOperation.get("address").set(activeMQPathAddress.append("runtime-queue", queueName).toModelNode());
        context.addStep(forwardOperation, handler, OperationContext.Stage.RUNTIME, true);
        return true;
    }

    private static enum RoutingType {
        MULTICAST,
        ANYCAST;

    }
}

