/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.event.logger;

import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.event.logger.Event;
import org.wildfly.event.logger.EventLogger;
import org.wildfly.event.logger.LazyEvent;
import org.wildfly.event.logger.StandardEvent;

abstract class AbstractEventLogger
implements EventLogger {
    private final String eventSource;

    AbstractEventLogger(String eventSource) {
        this.eventSource = eventSource;
    }

    @Override
    public EventLogger log(Map<String, Object> event) {
        this.log(new StandardEvent(this.eventSource, event));
        return this;
    }

    @Override
    public EventLogger log(Supplier<Map<String, Object>> event) {
        this.log(new LazyEvent(this.eventSource, event));
        return this;
    }

    @Override
    public String getEventSource() {
        return this.eventSource;
    }

    abstract void log(Event var1);

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.eventSource + "]";
    }
}

