/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.naming.ConfigurationException;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.common.Assert;
import org.wildfly.common.expression.Expression;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.util.EnvironmentUtils;
import org.wildfly.naming.client.util.NetworkUtils;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;

public final class ProviderEnvironment {
    private static final long BACKOFF_MASK = 32767L;
    public static final long TIME_MASK = -32768L;
    private final List<URI> providerUris;
    private final ConcurrentHashMap<URI, Long> blocklist = new ConcurrentHashMap(0);
    private final Supplier<AuthenticationContext> authenticationContextSupplier;
    static final Supplier<AuthenticationContext> DEFAULT_AUTH_CTXT_SUPPLIER = new Supplier<AuthenticationContext>(){

        @Override
        public AuthenticationContext get() {
            return AuthenticationContext.captureCurrent();
        }
    };

    ProviderEnvironment(Builder builder) {
        List<URI> providerUris = builder.getProviderUris();
        this.providerUris = providerUris.isEmpty() ? Collections.emptyList() : (providerUris.size() == 1 ? Collections.singletonList(providerUris.get(0)) : Collections.unmodifiableList(new ArrayList<URI>(providerUris)));
        this.authenticationContextSupplier = builder.getAuthenticationContextSupplier();
    }

    public List<URI> getProviderUris() {
        return this.providerUris;
    }

    public ConcurrentMap<URI, Long> getBlocklist() {
        return this.blocklist;
    }

    public void updateBlocklist(URI location) {
        int backoff;
        long time;
        long next;
        Long entry;
        do {
            long next2;
            time = System.currentTimeMillis();
            entry = this.blocklist.get(location);
            if (entry != null || (entry = this.blocklist.putIfAbsent(location, next2 = (time >>> 15) + 3L << 15 | 2L)) != null) continue;
            return;
        } while (!this.blocklist.replace(location, entry, next = (time >>> 15) + (long)(backoff = (long)(backoff = (int)((entry & 0x7FFFL) << 1)) > 32767L ? backoff >> 1 : backoff) + 1L << 15 | (long)backoff));
    }

    public void dropFromBlocklist(URI location) {
        this.blocklist.remove(location);
    }

    public Supplier<AuthenticationContext> getAuthenticationContextSupplier() {
        return this.authenticationContextSupplier;
    }

    static final class FixedAuthenticationContextSupplier
    implements Supplier<AuthenticationContext> {
        private final AuthenticationContext context;
        private final boolean inherit;

        FixedAuthenticationContextSupplier(AuthenticationContext context, boolean inherit) {
            this.context = context;
            this.inherit = inherit;
        }

        @Override
        public AuthenticationContext get() {
            return this.inherit ? this.context.with(AuthenticationContext.captureCurrent()) : this.context;
        }
    }

    public static final class Builder {
        private final List<URI> providerUris = new ArrayList<URI>();
        private final Set<URI> encounteredUris = new HashSet<URI>();
        private Supplier<AuthenticationContext> authenticationContextSupplier = DEFAULT_AUTH_CTXT_SUPPLIER;
        private static final String REMOTE_CONNECTION_PREFIX = "remote.connection.";
        private static final int REMOTE_CONNECTION_PREFIX_LEN = "remote.connection.".length();
        private static final String CONNECT_OPTIONS_PREFIX = "jboss.naming.client.connect.options.";

        public Builder addProviderUri(URI uri) {
            Assert.checkNotNullParam("uri", uri);
            if (!this.encounteredUris.add(uri)) {
                Messages.log.ignoringDuplicateDestination(uri);
            }
            this.providerUris.add(uri);
            return this;
        }

        public Builder addProviderUris(Collection<URI> uris) {
            Assert.checkNotNullParam("uris", uris);
            for (URI uri : uris) {
                Assert.checkNotNullParam("uri", uri);
                this.providerUris.add(uri);
            }
            return this;
        }

        public Builder setAuthenticationContextSupplier(Supplier<AuthenticationContext> authenticationContextSupplier) {
            Assert.checkNotNullParam("authenticationContextSupplier", authenticationContextSupplier);
            this.authenticationContextSupplier = authenticationContextSupplier;
            return this;
        }

        List<URI> getProviderUris() {
            return this.providerUris;
        }

        Supplier<AuthenticationContext> getAuthenticationContextSupplier() {
            return this.authenticationContextSupplier;
        }

        /*
         * WARNING - void declaration
         */
        public Builder populateFromEnvironment(Map<String, ?> environment) throws NamingException {
            void var14_18;
            Assert.checkNotNullParam("environment", environment);
            ClassLoader classLoader = Builder.secureGetContextClassLoader();
            String userName = Builder.getEnvString(environment, "java.naming.security.principal", null, true);
            boolean gotProviders = this.populateProviderUris(environment);
            String securityProtocol = Builder.getEnvString(environment, "java.naming.security.protocol", null, true);
            String globalSslEnabledOption = Builder.getEnvString(environment, "remote.connectionprovider.create.options." + Options.SSL_ENABLED, null, true);
            boolean isSsl = globalSslEnabledOption != null ? Boolean.parseBoolean(globalSslEnabledOption) : securityProtocol != null && "ssl".equalsIgnoreCase(securityProtocol.trim());
            IdentityCredentials credentials = EnvironmentUtils.getSecurityCredentials(environment);
            boolean overrideDefaultAuth = credentials != null || userName != null;
            OptionMap remotingOptions = this.getOptionMap(environment, CONNECT_OPTIONS_PREFIX, Builder.class.getClassLoader());
            if (userName != null) {
                remotingOptions = Builder.setQuietLocalAuth(remotingOptions, false);
            }
            AuthenticationConfiguration globalAuthConf = RemotingOptions.mergeOptionsIntoAuthenticationConfiguration(remotingOptions, AuthenticationConfiguration.empty());
            if (userName != null) {
                globalAuthConf = globalAuthConf.useName(userName);
            }
            if (credentials != null) {
                globalAuthConf = globalAuthConf.useCredentials(credentials);
            }
            HashSet<String> connections = null;
            for (String string : environment.keySet()) {
                String name = Builder.connectionNameOf(string);
                if (name == null) continue;
                if (gotProviders) {
                    Messages.log.ignoringLegacyProperties();
                    break;
                }
                Messages.log.deprecatedProperties();
                if (connections == null) {
                    connections = new HashSet<String>();
                }
                connections.add(name);
            }
            HashMap<URI, AuthenticationConfiguration> overrides = null;
            if (!gotProviders && connections != null) {
                for (String connection : connections) {
                    URI uri;
                    String connectionPrefix = REMOTE_CONNECTION_PREFIX + connection + ".";
                    String connUserName = Builder.getEnvString(environment, connectionPrefix + "username", null, true);
                    String rawHostString = Builder.getEnvString(environment, connectionPrefix + "host", null, true);
                    String connHostName = NetworkUtils.formatPossibleIpv6Address(rawHostString);
                    String connPassword = Builder.getEnvString(environment, connectionPrefix + "password", null, true);
                    String connPasswordBase64 = Builder.getEnvString(environment, connectionPrefix + "password.base64", null, true);
                    String connCallbackHandlerClass = Builder.getEnvString(environment, connectionPrefix + "callback.handler.class", null, true);
                    boolean sslEnabled = Boolean.parseBoolean(Builder.getEnvString(environment, connectionPrefix + "connect.options." + Options.SSL_ENABLED, Boolean.toString(isSsl), true));
                    String protocol = Builder.getEnvString(environment, connectionPrefix + "protocol", sslEnabled ? "remote+https" : "remote+http", true);
                    int connPort = Builder.getEnvInt(environment, connectionPrefix + "port", sslEnabled ? 443 : 80, true);
                    CallbackHandler connCallbackHandler = null;
                    if (connCallbackHandlerClass != null) {
                        try {
                            Class<?> clazz = Class.forName(connCallbackHandlerClass, true, classLoader);
                            connCallbackHandler = (CallbackHandler)clazz.newInstance();
                        }
                        catch (ClassNotFoundException e) {
                            throw Messages.log.failedToLoadCallbackHandlerClass(e, connCallbackHandlerClass);
                        }
                        catch (Exception e) {
                            throw Messages.log.failedToInstantiateCallbackHandlerInstance(e, connCallbackHandlerClass);
                        }
                    }
                    OptionMap connRemotingOptions = this.getOptionMap(environment, connectionPrefix + "connect.options.", Builder.class.getClassLoader());
                    if (connCallbackHandler != null || connUserName != null) {
                        connRemotingOptions = Builder.setQuietLocalAuth(connRemotingOptions, false);
                    }
                    if (connHostName == null) continue;
                    try {
                        uri = new URI(protocol, null, connHostName, connPort, null, null, null);
                    }
                    catch (URISyntaxException e) {
                        throw Messages.log.invalidProviderGenerated(e);
                    }
                    if (connPassword != null || connPasswordBase64 != null || connCallbackHandler != null || connUserName != null) {
                        if (overrides == null) {
                            overrides = new HashMap<URI, AuthenticationConfiguration>();
                        }
                        AuthenticationConfiguration authConfig = RemotingOptions.mergeOptionsIntoAuthenticationConfiguration(connRemotingOptions, AuthenticationConfiguration.empty());
                        if (connUserName != null) {
                            authConfig = authConfig.useName(connUserName);
                        }
                        if (connCallbackHandler != null) {
                            authConfig = authConfig.useCallbackHandler(connCallbackHandler);
                        }
                        if (connPassword != null) {
                            authConfig = authConfig.usePassword(connPassword);
                        } else if (connPasswordBase64 != null) {
                            authConfig = authConfig.usePassword(CodePointIterator.ofString(connPasswordBase64).base64Decode().asUtf8String().drainToString());
                        }
                        overrides.putIfAbsent(uri, authConfig);
                    }
                    this.addProviderUri(uri);
                }
            }
            AuthenticationContext authenticationContext = AuthenticationContext.empty();
            if (overrides != null) {
                for (Map.Entry entry : overrides.entrySet()) {
                    URI key = (URI)entry.getKey();
                    AuthenticationConfiguration configuration = (AuthenticationConfiguration)entry.getValue();
                    MatchRule rule = Builder.ruleFromLocation(key);
                    AuthenticationContext authenticationContext2 = var14_18.with(rule, configuration);
                }
            }
            if (overrideDefaultAuth) {
                AuthenticationContext authenticationContext3 = var14_18.with(MatchRule.ALL, globalAuthConf);
            }
            if (overrideDefaultAuth || overrides != null) {
                void var14_21;
                this.setAuthenticationContextSupplier(new FixedAuthenticationContextSupplier((AuthenticationContext)var14_21, !overrideDefaultAuth));
            }
            return this;
        }

        private OptionMap getOptionMap(Map<String, ?> environment, String prefix, ClassLoader classLoader) {
            OptionMap.Builder builder = OptionMap.builder();
            builder.set(Options.SASL_POLICY_NOANONYMOUS, false);
            for (String name : environment.keySet()) {
                if (!name.startsWith(prefix)) continue;
                String optionName = name.substring(prefix.length());
                Option<?> option = Option.fromString(optionName, classLoader);
                Object valueObj = environment.get(name);
                if (valueObj == null) continue;
                builder.parse(option, valueObj.toString(), classLoader);
            }
            return builder.getMap();
        }

        private static MatchRule ruleFromLocation(URI uri) {
            String schemeSpecificPart;
            String path;
            int port;
            String host;
            MatchRule rule = MatchRule.ALL;
            String scheme = uri.getScheme();
            if (scheme != null) {
                rule = rule.matchProtocol(scheme);
            }
            if ((host = uri.getHost()) != null) {
                rule = rule.matchHost(host);
            }
            if ((port = uri.getPort()) != -1) {
                rule = rule.matchPort(port);
            }
            if ((path = uri.getPath()) != null && !path.isEmpty()) {
                rule = rule.matchPath(path);
            }
            if (path == null && port == -1 && host == null && (schemeSpecificPart = uri.getSchemeSpecificPart()) != null) {
                rule = rule.matchUrnName(schemeSpecificPart);
            }
            return rule;
        }

        private static String connectionNameOf(String key) {
            int idx;
            String connectionName;
            if (key.startsWith(REMOTE_CONNECTION_PREFIX) && !(connectionName = ((idx = key.indexOf(46, REMOTE_CONNECTION_PREFIX_LEN)) == -1 ? key.substring(REMOTE_CONNECTION_PREFIX_LEN) : key.substring(REMOTE_CONNECTION_PREFIX_LEN, idx)).trim()).isEmpty()) {
                return connectionName;
            }
            return null;
        }

        private boolean populateProviderUris(Map<String, ?> env) throws ConfigurationException {
            String providerUriString;
            Object urlString = env.get("java.naming.provider.url");
            if (urlString != null && !(providerUriString = Expression.compile(urlString.toString(), Expression.Flag.LENIENT_SYNTAX).evaluateWithPropertiesAndEnvironment(false)).isEmpty()) {
                String[] urls;
                for (String url : urls = providerUriString.split(",")) {
                    URI providerUri;
                    try {
                        providerUri = new URI(url.trim());
                    }
                    catch (URISyntaxException e) {
                        throw Messages.log.invalidProviderUri(e, url);
                    }
                    this.addProviderUri(providerUri);
                }
                return true;
            }
            return false;
        }

        public ProviderEnvironment build() {
            return new ProviderEnvironment(this);
        }

        private static String getEnvString(Map<String, ?> env, String propertyName, String defaultValue, boolean expand) {
            Object obj = env.get(propertyName);
            if (obj == null) {
                return defaultValue;
            }
            String str = obj.toString();
            if (expand) {
                Expression expression = Expression.compile(str, Expression.Flag.LENIENT_SYNTAX);
                return expression.evaluateWithPropertiesAndEnvironment(false);
            }
            return str.trim();
        }

        private static int getEnvInt(Map<String, ?> env, String propertyName, int defaultValue, boolean expand) throws ConfigurationException {
            String resultStr;
            Object obj = env.get(propertyName);
            if (obj == null) {
                return defaultValue;
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            String str = obj.toString();
            if (expand) {
                Expression expression = Expression.compile(str, Expression.Flag.LENIENT_SYNTAX);
                resultStr = expression.evaluateWithPropertiesAndEnvironment(false);
            } else {
                resultStr = str.trim();
            }
            try {
                return Integer.parseInt(resultStr);
            }
            catch (NumberFormatException e) {
                throw Messages.log.invalidNumericProperty(e, propertyName, resultStr);
            }
        }

        private static OptionMap setQuietLocalAuth(OptionMap optionMap, boolean useQuietAuth) {
            Sequence<Property> existingSaslProps = optionMap.get(Options.SASL_PROPERTIES);
            if (existingSaslProps != null) {
                for (Property prop : existingSaslProps) {
                    String propKey = prop.getKey();
                    if (!propKey.equals("wildfly.sasl.local-user.quiet-auth") && !propKey.equals("jboss.sasl.local-user.quiet-auth")) continue;
                    return optionMap;
                }
                existingSaslProps.add(Property.of("wildfly.sasl.local-user.quiet-auth", Boolean.toString(useQuietAuth)));
                return optionMap;
            }
            OptionMap.Builder updatedOptionMapBuilder = OptionMap.builder().addAll(optionMap);
            updatedOptionMapBuilder.set(Options.SASL_PROPERTIES, Sequence.of(new Property[]{Property.of("wildfly.sasl.local-user.quiet-auth", Boolean.toString(useQuietAuth))}));
            return updatedOptionMapBuilder.getMap();
        }

        private static ClassLoader secureGetContextClassLoader() {
            SecurityManager sm = System.getSecurityManager();
            ClassLoader contextClassLoader = sm != null ? AccessController.doPrivileged(Builder::getContextClassLoader) : Builder.getContextClassLoader();
            return contextClassLoader;
        }

        private static ClassLoader getContextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

