/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.stats.impl;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.SearchStatistics;
import org.infinispan.query.core.stats.SearchStatisticsSnapshot;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.core.stats.impl.SearchStatisticsImpl;
import org.infinispan.query.core.stats.impl.SearchStatisticsSnapshotImpl;
import org.infinispan.query.core.stats.impl.SecurityActions;
import org.infinispan.query.core.stats.impl.StatsTask;

@Scope(value=Scopes.NAMED_CACHE)
public class SearchStatsRetriever {
    @Inject
    LocalQueryStatistics localQueryStatistics;
    @Inject
    IndexStatistics localIndexStatistics;
    @Inject
    Cache<?, ?> cache;

    public SearchStatistics getSearchStatistics() {
        return new SearchStatisticsImpl(this.localQueryStatistics, this.localIndexStatistics);
    }

    public CompletionStage<SearchStatisticsSnapshot> getDistributedSearchStatistics() {
        StatsTask statsTask = new StatsTask(this.cache.getName());
        ClusterExecutor clusterExecutor = SecurityActions.getClusterExecutor(this.cache);
        ConcurrentLinkedQueue stats = new ConcurrentLinkedQueue();
        return clusterExecutor.submitConsumer((Function)statsTask, (address, searchStats, throwable) -> {
            if (throwable != null) {
                Throwable rootCause = Util.getRootCause((Throwable)throwable);
                throw new CacheException("Error obtaining statistics from node", rootCause);
            }
            stats.add(searchStats);
        }).thenApply(v -> stats.stream().reduce(new SearchStatisticsSnapshotImpl(), SearchStatisticsSnapshot::merge));
    }
}

