/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.rest;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.smallrye.opentelemetry.api.OpenTelemetryConfig;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collections;
import java.util.List;

@Provider
public class OpenTelemetryServerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private Instrumenter<ContainerRequestContext, ContainerResponseContext> instrumenter;
    @jakarta.ws.rs.core.Context
    ResourceInfo resourceInfo;

    public OpenTelemetryServerFilter() {
    }

    @Inject
    public OpenTelemetryServerFilter(OpenTelemetry openTelemetry) {
        HttpServerAttributesExtractor serverAttributesExtractor = new HttpServerAttributesExtractor();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"io.smallrye.opentelemetry", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)serverAttributesExtractor));
        builder.setInstrumentationVersion(OpenTelemetryConfig.INSTRUMENTATION_VERSION);
        this.instrumenter = builder.setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)serverAttributesExtractor)).addAttributesExtractor(io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor.create((HttpServerAttributesGetter)serverAttributesExtractor, (io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter)new NetServerAttributesGetter())).buildServerInstrumenter((TextMapGetter)new ContainerRequestContextTextMapGetter());
    }

    public void filter(ContainerRequestContext request) {
        Context parentContext;
        if (this.instrumenter != null && this.instrumenter.shouldStart(parentContext = Context.current(), (Object)request)) {
            request.setProperty("rest.resource.class", (Object)this.resourceInfo.getResourceClass());
            request.setProperty("rest.resource.method", (Object)this.resourceInfo.getResourceMethod());
            Context spanContext = this.instrumenter.start(parentContext, (Object)request);
            Scope scope = spanContext.makeCurrent();
            request.setProperty("otel.span.server.context", (Object)spanContext);
            request.setProperty("otel.span.server.parentContext", (Object)parentContext);
            request.setProperty("otel.span.server.scope", (Object)scope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        if (this.instrumenter != null) {
            Scope scope = (Scope)request.getProperty("otel.span.server.scope");
            if (scope == null) {
                return;
            }
            Context spanContext = (Context)request.getProperty("otel.span.server.context");
            try {
                this.instrumenter.end(spanContext, (Object)request, (Object)response, null);
            }
            finally {
                scope.close();
                request.removeProperty("rest.resource.class");
                request.removeProperty("rest.resource.method");
                request.removeProperty("otel.span.server.context");
                request.removeProperty("otel.span.server.parentContext");
                request.removeProperty("otel.span.server.scope");
            }
        }
    }

    private static class HttpServerAttributesExtractor
    implements HttpServerAttributesGetter<ContainerRequestContext, ContainerResponseContext> {
        private HttpServerAttributesExtractor() {
        }

        public String getUrlPath(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getPath();
        }

        public String getUrlQuery(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getQuery();
        }

        public String getHttpRoute(ContainerRequestContext request) {
            try {
                Class resource = (Class)request.getProperty("rest.resource.class");
                Method method = (Method)request.getProperty("rest.resource.method");
                UriBuilder uriBuilder = UriBuilder.newInstance();
                String contextRoot = request.getUriInfo().getBaseUri().getPath();
                if (contextRoot != null) {
                    uriBuilder.path(contextRoot);
                }
                uriBuilder.path(resource);
                if (method.isAnnotationPresent(Path.class)) {
                    uriBuilder.path(method);
                }
                return uriBuilder.toTemplate();
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public String getUrlScheme(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getScheme();
        }

        public String getHttpRequestMethod(ContainerRequestContext request) {
            return request.getMethod();
        }

        public List<String> getHttpRequestHeader(ContainerRequestContext request, String name) {
            return (List)request.getHeaders().getOrDefault((Object)name, Collections.emptyList());
        }

        public Integer getHttpResponseStatusCode(ContainerRequestContext request, ContainerResponseContext response, Throwable throwable) {
            return response.getStatus();
        }

        public List<String> getHttpResponseHeader(ContainerRequestContext request, ContainerResponseContext response, String name) {
            return (List)response.getStringHeaders().getOrDefault((Object)name, Collections.emptyList());
        }
    }

    private static class NetServerAttributesGetter
    implements io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter<ContainerRequestContext, ContainerResponseContext> {
        private NetServerAttributesGetter() {
        }

        public String getTransport(ContainerRequestContext request) {
            return "ip_tcp";
        }

        public String getNetworkProtocolName(ContainerRequestContext request, ContainerResponseContext response) {
            return (String)request.getProperty(SemanticAttributes.NET_PROTOCOL_NAME.getKey());
        }

        public String getNetworkProtocolVersion(ContainerRequestContext request, ContainerResponseContext response) {
            return (String)request.getProperty(SemanticAttributes.NET_PROTOCOL_VERSION.getKey());
        }

        public String getServerAddress(ContainerRequestContext request) {
            return request.getUriInfo().getRequestUri().getHost();
        }

        public Integer getServerPort(ContainerRequestContext request) {
            URI uri = request.getUriInfo().getRequestUri();
            if (uri.getPort() > 0) {
                return uri.getPort();
            }
            try {
                return uri.toURL().getDefaultPort();
            }
            catch (MalformedURLException ex) {
                return -1;
            }
        }

        public InetSocketAddress getServerInetSocketAddress(ContainerRequestContext request, ContainerResponseContext response) {
            String serverAddress = this.getServerAddress(request);
            Integer serverPort = this.getServerPort(request);
            if (serverAddress != null && serverPort != null) {
                return new InetSocketAddress(serverAddress, (int)serverPort);
            }
            return null;
        }
    }

    private static class ContainerRequestContextTextMapGetter
    implements TextMapGetter<ContainerRequestContext> {
        private ContainerRequestContextTextMapGetter() {
        }

        public Iterable<String> keys(ContainerRequestContext carrier) {
            return carrier.getHeaders().keySet();
        }

        public String get(ContainerRequestContext carrier, String key) {
            if (carrier == null) {
                return null;
            }
            return (String)((List)carrier.getHeaders().getOrDefault((Object)key, Collections.singletonList(null))).get(0);
        }
    }
}

