/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import jakarta.ejb.Init;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.metadata.MethodAnnotationAggregator;
import org.jboss.as.ee.metadata.RuntimeAnnotationInformation;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.deployment.processors.dd.MethodResolutionUtils;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.ejb.spec.InitMethodMetaData;
import org.jboss.metadata.ejb.spec.InitMethodsMetaData;
import org.jboss.metadata.ejb.spec.SessionBean31MetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;

public class InitMethodMergingProcessor
extends AbstractMergingProcessor<StatefulComponentDescription> {
    public InitMethodMergingProcessor() {
        super(StatefulComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, StatefulComponentDescription description) throws DeploymentUnitProcessingException {
        RuntimeAnnotationInformation init = MethodAnnotationAggregator.runtimeAnnotationInformation(componentClass, (EEApplicationClasses)applicationClasses, (DeploymentReflectionIndex)deploymentReflectionIndex, Init.class);
        for (Map.Entry entry : init.getMethodAnnotations().entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            String value = (String)((List)entry.getValue()).get(0);
            if (value != null && !value.isEmpty()) {
                description.addInitMethod((Method)entry.getKey(), value);
                continue;
            }
            description.addInitMethod((Method)entry.getKey(), null);
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, StatefulComponentDescription description) throws DeploymentUnitProcessingException {
        SessionBean31MetaData metaData;
        InitMethodsMetaData inits;
        for (Class<?> clazz = componentClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
            ClassReflectionIndex index = deploymentReflectionIndex.getClassIndex(clazz);
            for (Method method : index.getMethods()) {
                if (!method.getName().startsWith("ejbCreate") || description.getInitMethods().containsKey(method)) continue;
                description.addInitMethod(method, null);
            }
        }
        SessionBeanMetaData data = description.getDescriptorData();
        if (data instanceof SessionBean31MetaData && (inits = (metaData = (SessionBean31MetaData)data).getInitMethods()) != null) {
            for (InitMethodMetaData method : inits) {
                Method beanMethod = MethodResolutionUtils.resolveMethod(method.getBeanMethod(), componentClass, deploymentReflectionIndex);
                if (method.getCreateMethod() != null) {
                    description.addInitMethod(beanMethod, method.getCreateMethod().getMethodName());
                    continue;
                }
                description.addInitMethod(beanMethod, null);
            }
        }
    }
}

