/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.wst11.stub;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices.wsarjtx.ArjunaTXConstants;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsat.client.CompletionCoordinatorRPCClient;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.CompletionCoordinatorParticipant;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;

public class CompletionRPCStub
implements CompletionCoordinatorParticipant {
    private W3CEndpointReference _completionCoordinator = null;
    private String _id;

    public CompletionRPCStub(String id, W3CEndpointReference completionCoordinator) throws Exception {
        this._completionCoordinator = completionCoordinator;
        this._id = id;
    }

    @Override
    public void commit() throws TransactionRolledBackException, UnknownTransactionException, SystemException {
        boolean result;
        MAP map = AddressingHelper.createNotificationContext(MessageId.getMessageId());
        try {
            result = CompletionCoordinatorRPCClient.getClient().sendCommit(this._completionCoordinator, map);
        }
        catch (SoapFault soapFault) {
            if (ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME.equals(soapFault.getSubcode())) {
                throw new UnknownTransactionException(soapFault.getMessage());
            }
            throw new SystemException(soapFault.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new SystemException(th.getMessage());
        }
        if (!result) {
            throw new TransactionRolledBackException();
        }
    }

    @Override
    public void rollback() throws UnknownTransactionException, SystemException {
        MAP map = AddressingHelper.createNotificationContext(MessageId.getMessageId());
        try {
            CompletionCoordinatorRPCClient.getClient().sendRollback(this._completionCoordinator, map);
        }
        catch (SoapFault soapFault) {
            if (ArjunaTXConstants.UNKNOWNTRANSACTION_ERROR_CODE_QNAME.equals(soapFault.getSubcode())) {
                throw new UnknownTransactionException(soapFault.getMessage());
            }
            throw new SystemException(soapFault.getMessage());
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new SystemException(th.getMessage());
        }
    }
}

