/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.opentelemetry;

import io.smallrye.opentelemetry.implementation.cdi.OpenTelemetryExtension;
import jakarta.enterprise.inject.spi.Extension;
import java.util.HashMap;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.wildfly.extension.opentelemetry.OpenTelemetryExtensionLogger;
import org.wildfly.extension.opentelemetry.api.OpenTelemetryCdiExtension;
import org.wildfly.extension.opentelemetry.api.WildFlyOpenTelemetryConfig;

class OpenTelemetryDeploymentProcessor
implements DeploymentUnitProcessor {
    private final boolean useServerConfig;
    private final WildFlyOpenTelemetryConfig serverConfig;

    public OpenTelemetryDeploymentProcessor(boolean useServerConfig, WildFlyOpenTelemetryConfig serverConfig) {
        this.useServerConfig = useServerConfig;
        this.serverConfig = serverConfig;
    }

    public void deploy(DeploymentPhaseContext deploymentPhaseContext) throws DeploymentUnitProcessingException {
        OpenTelemetryExtensionLogger.OTEL_LOGGER.debug("OpenTelemetry Subsystem is processing deployment");
        DeploymentUnit deploymentUnit = deploymentPhaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        try {
            WeldCapability weldCapability = (WeldCapability)((CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT)).getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
            if (!weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
                OpenTelemetryExtensionLogger.OTEL_LOGGER.debug("The deployment does not have Jakarta Contexts and Dependency Injection enabled. Skipping OpenTelemetry integration.");
                return;
            }
            HashMap<String, String> config = new HashMap<String, String>(this.serverConfig.properties());
            config.put("otel.service.name", this.getServiceName(deploymentUnit));
            weldCapability.registerExtensionInstance((Extension)new OpenTelemetryCdiExtension(this.useServerConfig, config), deploymentUnit);
            weldCapability.registerExtensionInstance((Extension)new OpenTelemetryExtension(), deploymentUnit);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw OpenTelemetryExtensionLogger.OTEL_LOGGER.deploymentRequiresCapability(deploymentPhaseContext.getDeploymentUnit().getName(), "org.wildfly.weld");
        }
    }

    private String getServiceName(DeploymentUnit deploymentUnit) {
        Object serviceName = deploymentUnit.getServiceName().getSimpleName();
        if (null != deploymentUnit.getParent()) {
            serviceName = deploymentUnit.getParent().getServiceName().getSimpleName() + "!" + (String)serviceName;
        }
        return serviceName;
    }
}

