/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager5;
import org.apache.activemq.artemis.spi.core.security.jaas.JaasCallbackHandler;
import org.apache.activemq.artemis.spi.core.security.jaas.NoCacheLoginException;
import org.apache.activemq.artemis.utils.SecurityManagerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQJAASSecurityManager
implements ActiveMQSecurityManager5 {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String configurationName;
    private String certificateConfigurationName;
    private SecurityConfiguration configuration;
    private SecurityConfiguration certificateConfiguration;
    private String rolePrincipalClass = "org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal";

    public ActiveMQJAASSecurityManager() {
    }

    public ActiveMQJAASSecurityManager(String configurationName) {
        this.configurationName = configurationName;
    }

    public ActiveMQJAASSecurityManager(String configurationName, String certificateConfigurationName) {
        this.configurationName = configurationName;
        this.certificateConfigurationName = certificateConfigurationName;
    }

    public ActiveMQJAASSecurityManager(String configurationName, SecurityConfiguration configuration) {
        this.configurationName = configurationName;
        this.configuration = configuration;
    }

    public ActiveMQJAASSecurityManager(String configurationName, String certificateConfigurationName, SecurityConfiguration configuration, SecurityConfiguration certificateConfiguration) {
        this.configurationName = configurationName;
        this.configuration = configuration;
        this.certificateConfigurationName = certificateConfigurationName;
        this.certificateConfiguration = certificateConfiguration;
    }

    @Override
    public String getDomain() {
        return this.configurationName;
    }

    @Override
    public boolean validateUser(String user, String password) {
        throw new UnsupportedOperationException("Invoke validateUser(String, String, RemotingConnection, String) instead");
    }

    @Override
    public Subject authenticate(String user, String password, RemotingConnection remotingConnection, String securityDomain) throws NoCacheLoginException {
        try {
            return this.getAuthenticatedSubject(user, password, remotingConnection, securityDomain);
        }
        catch (LoginException e) {
            logger.debug("Couldn't validate user", (Throwable)e);
            if (e instanceof NoCacheLoginException) {
                throw (NoCacheLoginException)e;
            }
            return null;
        }
    }

    @Override
    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        throw new UnsupportedOperationException("Invoke validateUserAndRole(String, String, Set<Role>, CheckType, String, RemotingConnection, String) instead");
    }

    @Override
    public boolean authorize(Subject subject, Set<Role> roles, CheckType checkType, String address) {
        boolean authorized = SecurityManagerUtil.authorize(subject, roles, checkType, this.rolePrincipalClass);
        if (authorized) {
            logger.trace("user is authorized");
        } else {
            logger.trace("user is NOT authorized");
        }
        return authorized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subject getAuthenticatedSubject(String user, String password, RemotingConnection remotingConnection, String securityDomain) throws LoginException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader thisLoader = this.getClass().getClassLoader();
        try {
            if (thisLoader != currentLoader) {
                Thread.currentThread().setContextClassLoader(thisLoader);
            }
            LoginContext lc = securityDomain != null ? new LoginContext(securityDomain, null, new JaasCallbackHandler(user, password, remotingConnection), null) : (this.certificateConfigurationName != null && this.certificateConfigurationName.length() > 0 && CertificateUtil.getCertsFromConnection((RemotingConnection)remotingConnection) != null ? new LoginContext(this.certificateConfigurationName, null, new JaasCallbackHandler(user, password, remotingConnection), this.certificateConfiguration) : new LoginContext(this.configurationName, null, new JaasCallbackHandler(user, password, remotingConnection), this.configuration));
            lc.login();
            Subject subject = lc.getSubject();
            return subject;
        }
        finally {
            if (thisLoader != currentLoader) {
                Thread.currentThread().setContextClassLoader(currentLoader);
            }
        }
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public void setConfiguration(SecurityConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setCertificateConfigurationName(String certificateConfigurationName) {
        this.certificateConfigurationName = certificateConfigurationName;
    }

    public void setCertificateConfiguration(SecurityConfiguration certificateConfiguration) {
        this.certificateConfiguration = certificateConfiguration;
    }

    public SecurityConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new SecurityConfiguration();
        }
        return this.configuration;
    }

    public SecurityConfiguration getCertificateConfiguration() {
        if (this.certificateConfiguration == null) {
            this.certificateConfiguration = new SecurityConfiguration();
        }
        return this.certificateConfiguration;
    }

    public String getRolePrincipalClass() {
        return this.rolePrincipalClass;
    }

    public void setRolePrincipalClass(String rolePrincipalClass) {
        this.rolePrincipalClass = rolePrincipalClass;
    }
}

