/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.function.SerializablePredicate;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.IdentifierFactory;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.ee.infinispan.affinity.AffinityIdentifierFactory;
import org.wildfly.clustering.ee.infinispan.scheduler.CacheEntryScheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleLocalKeysTask;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleWithMetaDataCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.ScheduleWithTransientMetaDataCommand;
import org.wildfly.clustering.ee.infinispan.scheduler.SchedulerTopologyChangeListener;
import org.wildfly.clustering.ejb.cache.timer.IntervalTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.RemappableTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.ScheduleTimerMetaDataEntry;
import org.wildfly.clustering.ejb.cache.timer.TimerFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerIndex;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.timer.InfinispanTimerMetaDataKey;
import org.wildfly.clustering.ejb.infinispan.timer.TimerMetaDataKeyFilter;
import org.wildfly.clustering.ejb.infinispan.timer.TimerScheduler;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.IntervalTimerConfiguration;
import org.wildfly.clustering.ejb.timer.ScheduleTimerConfiguration;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.infinispan.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.distribution.Locality;
import org.wildfly.clustering.infinispan.distribution.SimpleLocality;
import org.wildfly.clustering.infinispan.listener.ListenerRegistration;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.server.group.Group;

public class InfinispanTimerManager<I, C>
implements TimerManager<I, TransactionBatch> {
    private final Cache<Key<I>, ?> cache;
    private final CacheProperties properties;
    private final TimerFactory<I, RemappableTimerMetaDataEntry<C>, C> factory;
    private final Marshaller<Object, C> marshaller;
    private final IdentifierFactory<I> identifierFactory;
    private final Batcher<TransactionBatch> batcher;
    private final CommandDispatcherFactory dispatcherFactory;
    private final Group<Address> group;
    private final TimerRegistry<I> registry;
    private volatile Scheduler<I, ImmutableTimerMetaData> scheduledTimers;
    private volatile Scheduler<I, ImmutableTimerMetaData> scheduler;
    private volatile ListenerRegistration schedulerListenerRegistration;

    public InfinispanTimerManager(InfinispanTimerManagerConfiguration<I, C> config) {
        this.cache = config.getCache();
        this.properties = config.getCacheProperties();
        this.marshaller = config.getMarshaller();
        this.identifierFactory = new AffinityIdentifierFactory(config.getIdentifierFactory(), this.cache, config.getKeyAffinityServiceFactory());
        this.batcher = config.getBatcher();
        this.dispatcherFactory = config.getCommandDispatcherFactory();
        this.group = config.getGroup();
        this.factory = config.getTimerFactory();
        this.registry = config.getRegistry();
    }

    public void start() {
        Supplier<Locality> locality = () -> new CacheLocality(this.cache);
        PrimaryOwnerScheduler localScheduler = new TimerScheduler(this.factory, this, locality, Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout()), this.registry);
        this.scheduledTimers = localScheduler;
        this.scheduler = this.group.isSingleton() ? localScheduler : new PrimaryOwnerScheduler(this.dispatcherFactory, this.cache.getName(), (CacheEntryScheduler)localScheduler, (Function)new PrimaryOwnerLocator(this.cache, this.group), InfinispanTimerMetaDataKey::new, this.properties.isTransactional() ? ScheduleWithMetaDataCommand::new : ScheduleWithTransientMetaDataCommand::new);
        TimerRegistry<I> registry = this.registry;
        ScheduleLocalKeysTask scheduleTask = new ScheduleLocalKeysTask(this.cache, (Predicate)((Object)TimerMetaDataKeyFilter.INSTANCE), new Consumer<I>((TimerScheduler)localScheduler, registry){
            final /* synthetic */ TimerScheduler val$localScheduler;
            final /* synthetic */ TimerRegistry val$registry;
            {
                this.val$localScheduler = timerScheduler;
                this.val$registry = timerRegistry;
            }

            @Override
            public void accept(I id) {
                this.val$localScheduler.schedule(id);
                this.val$registry.register(id);
            }
        });
        this.schedulerListenerRegistration = new SchedulerTopologyChangeListener(this.cache, (CacheEntryScheduler)localScheduler, (BiConsumer)scheduleTask).register();
        scheduleTask.accept(new SimpleLocality(false), new CacheLocality(this.cache));
        this.identifierFactory.start();
    }

    public void stop() {
        Scheduler<I, ImmutableTimerMetaData> scheduler;
        this.identifierFactory.stop();
        ListenerRegistration registration = this.schedulerListenerRegistration;
        if (registration != null) {
            registration.close();
        }
        if ((scheduler = this.scheduler) != null) {
            scheduler.close();
        }
    }

    public Timer<I> createTimer(I id, IntervalTimerConfiguration config, Object context) {
        try {
            IntervalTimerMetaDataEntry entry = new IntervalTimerMetaDataEntry(this.marshaller.write(context), config);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer<I> createTimer(I id, ScheduleTimerConfiguration config, Object context) {
        try {
            ScheduleTimerMetaDataEntry entry = new ScheduleTimerMetaDataEntry(this.marshaller.write(context), config);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Timer<I> createTimer(I id, ScheduleTimerConfiguration config, Object context, Method method, int index) {
        try {
            ScheduleTimerMetaDataEntry entry = new ScheduleTimerMetaDataEntry(this.marshaller.write(context), config, method);
            return this.createTimer(id, (RemappableTimerMetaDataEntry<C>)entry, new TimerIndex(method, index));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Timer<I> createTimer(I id, RemappableTimerMetaDataEntry<C> entry, TimerIndex index) {
        TimerMetaDataFactory metaDataFactory = this.factory.getMetaDataFactory();
        if (metaDataFactory.createValue(id, new AbstractMap.SimpleImmutableEntry<RemappableTimerMetaDataEntry<C>, TimerIndex>(entry, index)) == null) {
            return null;
        }
        ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData(entry);
        Timer timer = this.factory.createTimer(id, metaData, (TimerManager)this, this.scheduledTimers);
        return timer;
    }

    public Timer<I> getTimer(I id) {
        TimerMetaDataFactory metaDataFactory = this.factory.getMetaDataFactory();
        RemappableTimerMetaDataEntry entry = (RemappableTimerMetaDataEntry)metaDataFactory.findValue(id);
        if (entry != null) {
            ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData((Object)entry);
            return this.factory.createTimer(id, metaData, (TimerManager)this, this.scheduledTimers);
        }
        return null;
    }

    public Stream<I> getActiveTimers() {
        return this.group.isSingleton() ? this.scheduledTimers.stream() : this.cache.keySet().stream().filter((SerializablePredicate)TimerMetaDataKeyFilter.INSTANCE).map(Key::getId);
    }

    public Supplier<I> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public String toString() {
        return this.cache.getName();
    }
}

