/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.timer;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.wildfly.clustering.context.DefaultThreadFactory;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.scheduler.LocalScheduler;
import org.wildfly.clustering.ee.cache.scheduler.ScheduledEntries;
import org.wildfly.clustering.ee.cache.scheduler.SortedScheduledEntries;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.ee.infinispan.scheduler.AbstractCacheEntryScheduler;
import org.wildfly.clustering.ejb.cache.timer.TimerFactory;
import org.wildfly.clustering.ejb.cache.timer.TimerMetaDataFactory;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.ejb.timer.ImmutableTimerMetaData;
import org.wildfly.clustering.ejb.timer.Timer;
import org.wildfly.clustering.ejb.timer.TimerManager;
import org.wildfly.clustering.ejb.timer.TimerMetaData;
import org.wildfly.clustering.ejb.timer.TimerRegistry;
import org.wildfly.clustering.infinispan.distribution.Locality;

public class TimerScheduler<I, V, C>
extends AbstractCacheEntryScheduler<I, ImmutableTimerMetaData> {
    private static final ThreadFactory THREAD_FACTORY = new DefaultThreadFactory(TimerScheduler.class);
    private final TimerFactory<I, V, C> factory;

    public TimerScheduler(TimerFactory<I, V, C> factory, TimerManager<I, TransactionBatch> manager, Supplier<Locality> locality, Duration closeTimeout, TimerRegistry<I> registry) {
        this(factory, manager, locality, closeTimeout, registry, (ScheduledEntries<I, Instant>)new SortedScheduledEntries(), Executors.newSingleThreadExecutor(THREAD_FACTORY));
    }

    private TimerScheduler(TimerFactory<I, V, C> factory, TimerManager<I, TransactionBatch> manager, Supplier<Locality> locality, Duration closeTimeout, TimerRegistry<I> registry, ScheduledEntries<I, Instant> entries, ExecutorService executor) {
        this(entries, (Predicate<I> & Consumer<Scheduler<I, ImmutableTimerMetaData>>)new InvokeTask<I, V, C>(factory, manager, locality, entries, registry, executor), closeTimeout, registry, executor, factory);
    }

    private <T extends Predicate<I> & Consumer<Scheduler<I, ImmutableTimerMetaData>>> TimerScheduler(ScheduledEntries<I, Instant> entries, T invokeTask, Duration closeTimeout, final TimerRegistry<I> registry, final ExecutorService executor, TimerFactory<I, V, C> factory) {
        this((Scheduler<I, Instant>)new LocalScheduler<I>(entries, invokeTask, closeTimeout){

            public void cancel(I id) {
                registry.unregister(id);
                super.cancel(id);
            }

            public void close() {
                super.close();
                executor.shutdown();
            }
        }, invokeTask, factory);
    }

    private TimerScheduler(Scheduler<I, Instant> scheduler, Consumer<Scheduler<I, ImmutableTimerMetaData>> injector, TimerFactory<I, V, C> factory) {
        super(scheduler, ImmutableTimerMetaData::getNextTimeout);
        this.factory = factory;
        injector.accept((Scheduler<I, ImmutableTimerMetaData>)this);
    }

    public void schedule(I id) {
        TimerMetaDataFactory metaDataFactory = this.factory.getMetaDataFactory();
        Object value = metaDataFactory.findValue(id);
        if (value != null) {
            ImmutableTimerMetaData metaData = metaDataFactory.createImmutableTimerMetaData(value);
            this.schedule(id, metaData);
        }
    }

    private static class InvokeTask<I, V, C>
    implements Predicate<I>,
    Consumer<Scheduler<I, ImmutableTimerMetaData>> {
        private final TimerFactory<I, V, C> factory;
        private final TimerManager<I, TransactionBatch> manager;
        private final Supplier<Locality> locality;
        private final ScheduledEntries<I, Instant> entries;
        private final TimerRegistry<I> registry;
        private final ExecutorService executor;
        private Scheduler<I, ImmutableTimerMetaData> scheduler;

        InvokeTask(TimerFactory<I, V, C> factory, TimerManager<I, TransactionBatch> manager, Supplier<Locality> locality, ScheduledEntries<I, Instant> entries, TimerRegistry<I> registry, ExecutorService executor) {
            this.factory = factory;
            this.manager = manager;
            this.locality = locality;
            this.entries = entries;
            this.registry = registry;
            this.executor = executor;
        }

        @Override
        public void accept(Scheduler<I, ImmutableTimerMetaData> scheduler) {
            this.scheduler = scheduler;
        }

        @Override
        public boolean test(final I id) {
            final TimerFactory<I, V, C> factory = this.factory;
            final TimerManager<I, TransactionBatch> manager = this.manager;
            final Supplier<Locality> locality = this.locality;
            final ScheduledEntries<I, Instant> entries = this.entries;
            final TimerRegistry<I> registry = this.registry;
            final Scheduler<I, ImmutableTimerMetaData> scheduler = this.scheduler;
            if (!locality.get().isLocal((Object)new GroupedKey(id))) {
                InfinispanEjbLogger.ROOT_LOGGER.debugf("Skipping timeout processing of non-local timer %s", id);
                return true;
            }
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    InfinispanEjbLogger.ROOT_LOGGER.debugf("Initiating timeout for timer %s", id);
                    TimerMetaDataFactory metaDataFactory = factory.getMetaDataFactory();
                    try (TransactionBatch batch = (TransactionBatch)manager.getBatcher().createBatch();){
                        Object value = metaDataFactory.findValue(id);
                        if (value == null) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Timer not found %s", id);
                            Boolean bl = true;
                            return bl;
                        }
                        TimerMetaData metaData = metaDataFactory.createTimerMetaData(id, value);
                        Optional currentTimeoutReference = metaData.getNextTimeout();
                        if (currentTimeoutReference.isEmpty()) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Unexpected timeout event triggered.", id);
                            Boolean bl = false;
                            return bl;
                        }
                        Instant currentTimeout = (Instant)currentTimeoutReference.get();
                        if (currentTimeout.isAfter(Instant.now())) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Timeout for timer %s initiated prematurely.", id);
                            Boolean bl = false;
                            return bl;
                        }
                        Timer timer = factory.createTimer(id, (ImmutableTimerMetaData)metaData, manager, scheduler);
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Triggering timeout for timer %s [%s]", id, timer.getMetaData().getContext());
                        Optional lastTimeout = metaData.getLastTimeout();
                        metaData.setLastTimeout(currentTimeout);
                        try {
                            timer.invoke();
                        }
                        catch (ExecutionException e) {
                            InfinispanEjbLogger.ROOT_LOGGER.error(e.getLocalizedMessage(), e);
                        }
                        catch (RejectedExecutionException e) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("EJB component is suspended - could not invoke timeout for timer %s", id);
                            metaData.setLastTimeout((Instant)lastTimeout.orElse(null));
                            Boolean bl = false;
                            if (batch != null) {
                                batch.close();
                            }
                            return bl;
                        }
                        if (timer.isCanceled()) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Timeout callback canceled timer %s", id);
                            Boolean e = true;
                            return e;
                        }
                        Optional nextTimeout = metaData.getNextTimeout();
                        if (nextTimeout.isEmpty()) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Timer %s has expired", id);
                            registry.unregister(id);
                            factory.getMetaDataFactory().remove(id);
                            Boolean bl = true;
                            return bl;
                        }
                        if (!((Locality)locality.get()).isLocal((Object)new GroupedKey(id))) {
                            InfinispanEjbLogger.ROOT_LOGGER.debugf("Timer %s is no longer local", id);
                            Boolean bl = true;
                            return bl;
                        }
                        InfinispanEjbLogger.ROOT_LOGGER.debugf("Rescheduling timer %s for next timeout %s", id, nextTimeout);
                        entries.add(id, (Object)((Instant)nextTimeout.get()));
                        Boolean bl = false;
                        return bl;
                    }
                }
            };
            try {
                Future<Boolean> result = this.executor.submit(task);
                return result.get();
            }
            catch (RejectedExecutionException e) {
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (ExecutionException e) {
                InfinispanEjbLogger.ROOT_LOGGER.info(e.getLocalizedMessage(), e);
                return false;
            }
        }
    }
}

