/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.security.password.OneWayPassword;
import org.wildfly.security.password.interfaces.RawUnixMD5CryptPassword;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public interface UnixMD5CryptPassword
extends OneWayPassword {
    public static final String ALGORITHM_CRYPT_MD5 = "crypt-md5";
    public static final int SALT_SIZE = 8;
    public static final int ITERATION_COUNT = 1000;

    public byte[] getSalt();

    public byte[] getHash();

    @Override
    default public SaltedPasswordAlgorithmSpec getParameterSpec() {
        return new SaltedPasswordAlgorithmSpec(this.getSalt());
    }

    @Override
    default public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam("parameterSpec", parameterSpec);
        if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
            IteratedSaltedPasswordAlgorithmSpec spec = (IteratedSaltedPasswordAlgorithmSpec)parameterSpec;
            return 1000 == spec.getIterationCount() && Arrays.equals(this.getSalt(), spec.getSalt());
        }
        if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
            return Arrays.equals(this.getSalt(), ((SaltedPasswordAlgorithmSpec)parameterSpec).getSalt());
        }
        if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
            return 1000 == ((IteratedPasswordAlgorithmSpec)parameterSpec).getIterationCount();
        }
        return false;
    }

    @Override
    public UnixMD5CryptPassword clone();

    public static UnixMD5CryptPassword createRaw(String algorithm, byte[] salt, byte[] hash) {
        Assert.checkNotNullParam("algorithm", algorithm);
        Assert.checkNotNullParam("salt", salt);
        Assert.checkNotNullParam("hash", hash);
        return new RawUnixMD5CryptPassword(algorithm, salt, hash);
    }
}

