/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.commit;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.tuples.Tuple2;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.kafka.KafkaConsumer;
import io.smallrye.reactive.messaging.kafka.commit.CheckpointStateStore;
import io.smallrye.reactive.messaging.kafka.commit.ProcessingState;
import io.smallrye.reactive.messaging.kafka.commit.ProcessingStateCodec;
import io.smallrye.reactive.messaging.kafka.commit.VertxJsonProcessingStateCodec;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.providers.helpers.CDIUtils;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;

public class FileCheckpointStateStore
implements CheckpointStateStore {
    public static final String STATE_STORE_NAME = "file";
    private final Vertx vertx;
    private final File stateDir;
    private final String consumerGroupId;
    private final ProcessingStateCodec codec;

    public FileCheckpointStateStore(Vertx vertx, String consumerGroupId, File stateDir, ProcessingStateCodec codec) {
        this.vertx = vertx;
        this.consumerGroupId = consumerGroupId;
        this.stateDir = stateDir;
        this.codec = codec;
    }

    public File getStateDir() {
        return this.stateDir;
    }

    private String getStatePath(TopicPartition partition) {
        return this.stateDir.toPath().resolve(this.consumerGroupId + ":" + partition.topic() + ":" + partition.partition()).toString();
    }

    @Override
    public Uni<Map<TopicPartition, ProcessingState<?>>> fetchProcessingState(Collection<TopicPartition> partitions) {
        return Multi.createFrom().iterable(partitions).onItem().transformToUniAndConcatenate(p -> this.fetchProcessingState((TopicPartition)p).map(s -> Tuple2.of((Object)p, (Object)s))).filter(t -> t.getItem2() != null).collect().asMap(Tuple2::getItem1, Tuple2::getItem2);
    }

    protected Uni<ProcessingState<?>> fetchProcessingState(TopicPartition partition) {
        String statePath = this.getStatePath(partition);
        return this.vertx.fileSystem().exists(statePath).chain(exists -> {
            if (exists.booleanValue()) {
                return this.vertx.fileSystem().readFile(statePath).map(this::deserializeState).onFailure().invoke(t -> KafkaLogging.log.errorf((Throwable)t, "Error fetching processing state for partition %s", partition)).onItem().invoke(r -> KafkaLogging.log.debugf("Fetched state for partition %s : %s", partition, r));
            }
            return Uni.createFrom().item(() -> null);
        });
    }

    private ProcessingState<?> deserializeState(Buffer b) {
        return this.codec.decode(b.getBytes());
    }

    @Override
    public Uni<Void> persistProcessingState(Map<TopicPartition, ProcessingState<?>> state) {
        return Multi.createFrom().iterable(state.entrySet()).onItem().transformToUniAndConcatenate(e -> this.persistProcessingState((TopicPartition)e.getKey(), (ProcessingState)e.getValue())).collect().asList().replaceWithVoid();
    }

    protected Uni<Void> persistProcessingState(TopicPartition partition, ProcessingState<?> state) {
        String statePath = this.getStatePath(partition);
        if (state != null) {
            return this.vertx.fileSystem().exists(statePath).chain(exists -> {
                if (exists.booleanValue()) {
                    return this.fetchProcessingState(partition).onFailure().recoverWithNull();
                }
                return this.vertx.fileSystem().createFile(statePath).onItem().transform(x -> null).onFailure(t -> Optional.ofNullable(t.getCause()).map(Object::getClass).orElse(null) == FileAlreadyExistsException.class).recoverWithNull();
            }).chain(s -> {
                if (s != null && s.getOffset() > state.getOffset()) {
                    KafkaLogging.log.warnf("Skipping persist operation : higher offset found on store %d > %d", s.getOffset(), state.getOffset());
                    return Uni.createFrom().voidItem();
                }
                return this.vertx.fileSystem().writeFile(statePath, this.serializeState(state));
            }).onFailure().invoke(t -> KafkaLogging.log.errorf((Throwable)t, "Error persisting processing state `%s` for partition %s", state, partition)).onItem().invoke(() -> KafkaLogging.log.debugf("Persisted state for partition %s : %s", partition, state));
        }
        return Uni.createFrom().voidItem();
    }

    private Buffer serializeState(ProcessingState<?> state) {
        return Buffer.buffer((byte[])this.codec.encode(state));
    }

    @ApplicationScoped
    @Identifier(value="file")
    public static class Factory
    implements CheckpointStateStore.Factory {
        private final Instance<ProcessingStateCodec.Factory> stateCodecFactory;

        @Inject
        public Factory(@Any Instance<ProcessingStateCodec.Factory> stateCodecFactory) {
            this.stateCodecFactory = stateCodecFactory;
        }

        @Override
        public CheckpointStateStore create(KafkaConnectorIncomingConfiguration config, Vertx vertx, KafkaConsumer<?, ?> consumer, Class<?> stateType) {
            String consumerGroupId = (String)consumer.configuration().get("group.id");
            Optional dir = config.config().getOptionalValue("checkpoint.file.state-dir", String.class);
            File stateDir = dir.map(File::new).orElseGet(() -> {
                try {
                    return Files.createTempDirectory("io.smallrye.reactive.messaging.kafka", new FileAttribute[0]).toFile();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
            ProcessingStateCodec stateCodec = ((ProcessingStateCodec.Factory)CDIUtils.getInstanceById(this.stateCodecFactory, (String)config.getChannel(), () -> {
                if (this.stateCodecFactory.isUnsatisfied()) {
                    return VertxJsonProcessingStateCodec.FACTORY;
                }
                return (ProcessingStateCodec.Factory)this.stateCodecFactory.get();
            })).create(stateType);
            return new FileCheckpointStateStore(vertx, consumerGroupId, stateDir, stateCodec);
        }
    }
}

