/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.sso;

import org.wildfly.clustering.ee.cache.IdentifierFactory;
import org.wildfly.clustering.ee.cache.SimpleIdentifierFactory;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.hotrod.HotRodConfiguration;
import org.wildfly.clustering.marshalling.spi.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.spi.MarshalledValueMarshaller;
import org.wildfly.clustering.web.cache.sso.CompositeSSOManager;
import org.wildfly.clustering.web.hotrod.sso.HotRodSSOFactory;
import org.wildfly.clustering.web.hotrod.sso.coarse.CoarseSessionsFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerConfiguration;
import org.wildfly.clustering.web.sso.SSOManagerFactory;

public class HotRodSSOManagerFactory<A, D, S>
implements SSOManagerFactory<A, D, S, TransactionBatch> {
    private final HotRodConfiguration configuration;

    public HotRodSSOManagerFactory(HotRodConfiguration configuration) {
        this.configuration = configuration;
    }

    public <L> SSOManager<A, D, S, L, TransactionBatch> createSSOManager(SSOManagerConfiguration<L> config) {
        CoarseSessionsFactory sessionsFactory = new CoarseSessionsFactory(this.configuration);
        MarshalledValueMarshaller marshaller = new MarshalledValueMarshaller((MarshalledValueFactory)new ByteBufferMarshalledValueFactory(config.getMarshaller()));
        HotRodSSOFactory factory = new HotRodSSOFactory(this.configuration, marshaller, config.getLocalContextFactory(), sessionsFactory);
        SimpleIdentifierFactory identifierFactory = new SimpleIdentifierFactory(config.getIdentifierFactory());
        return new CompositeSSOManager(factory, (IdentifierFactory)identifierFactory, this.configuration.getBatcher());
    }
}

