/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.insert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.tree.AbstractSqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;

public abstract class AbstractSqmInsertStatement<T>
extends AbstractSqmDmlStatement<T>
implements SqmInsertStatement<T> {
    private List<SqmPath<?>> insertionTargetPaths;

    protected AbstractSqmInsertStatement(SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(querySource, nodeBuilder);
    }

    protected AbstractSqmInsertStatement(SqmRoot<T> targetRoot, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(targetRoot, querySource, nodeBuilder);
    }

    protected AbstractSqmInsertStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, SqmRoot<T> target, List<SqmPath<?>> insertionTargetPaths) {
        super(builder, querySource, parameters, cteStatements, target);
        this.insertionTargetPaths = insertionTargetPaths;
    }

    protected List<SqmPath<?>> copyInsertionTargetPaths(SqmCopyContext context) {
        if (this.insertionTargetPaths == null) {
            return null;
        }
        ArrayList insertionTargetPaths = new ArrayList(this.insertionTargetPaths.size());
        for (SqmPath<?> insertionTargetPath : this.insertionTargetPaths) {
            insertionTargetPaths.add((SqmPath<?>)insertionTargetPath.copy(context));
        }
        return insertionTargetPaths;
    }

    @Override
    public List<SqmPath<?>> getInsertionTargetPaths() {
        return this.insertionTargetPaths == null ? Collections.emptyList() : Collections.unmodifiableList(this.insertionTargetPaths);
    }

    public void setInsertionTargetPaths(List<SqmPath<?>> insertionTargetPaths) {
        this.insertionTargetPaths = insertionTargetPaths;
    }

    public void addInsertTargetStateField(SqmPath<?> stateField) {
        if (this.insertionTargetPaths == null) {
            this.insertionTargetPaths = new ArrayList();
        }
        this.insertionTargetPaths.add(stateField);
    }

    @Override
    public void visitInsertionTargetPaths(Consumer<SqmPath<?>> consumer) {
        if (this.insertionTargetPaths != null) {
            this.insertionTargetPaths.forEach(consumer);
        }
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.appendHqlCteString(sb);
        sb.append("insert into ");
        sb.append(((SqmRoot)this.getTarget()).getEntityName());
        if (this.insertionTargetPaths != null && !this.insertionTargetPaths.isEmpty()) {
            sb.append('(');
            this.insertionTargetPaths.get(0).appendHqlString(sb);
            for (int i = 1; i < this.insertionTargetPaths.size(); ++i) {
                sb.append(", ");
                this.insertionTargetPaths.get(i).appendHqlString(sb);
            }
            sb.append(')');
        }
    }
}

