/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import javax.naming.NamingException;
import org.jboss.remoting3.Endpoint;
import org.wildfly.naming.client.NamingProviderFactory;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.naming.client.util.FastHashtable;

public final class RemoteNamingProviderFactory
implements NamingProviderFactory {
    public static final String ENDPOINT = "wildfly.naming.client.endpoint";

    @Override
    public boolean supportsUriScheme(String providerScheme, FastHashtable<String, Object> env) {
        Endpoint endpoint = this.getEndpoint(env);
        return endpoint != null && endpoint.isValidUriScheme(providerScheme);
    }

    @Override
    public RemoteNamingProvider createProvider(FastHashtable<String, Object> env, ProviderEnvironment providerEnvironment) throws NamingException {
        return new RemoteNamingProvider(this.getEndpoint(env), providerEnvironment, env);
    }

    private Endpoint getEndpoint(FastHashtable<String, Object> env) {
        return env.containsKey(ENDPOINT) ? (Endpoint)env.get(ENDPOINT) : Endpoint.getCurrent();
    }
}

