/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.Map;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public final class FullTextTermExpr
implements PrimaryPredicateExpr {
    private final ValueExpr leftChild;
    private final String term;
    private final Integer fuzzySlop;
    private final ConstantValueExpr.ParamPlaceholder paramPlaceholder;

    public FullTextTermExpr(ValueExpr leftChild, Object comparisonObject, Integer fuzzySlop) {
        this.leftChild = leftChild;
        this.term = comparisonObject.toString();
        this.fuzzySlop = fuzzySlop;
        this.paramPlaceholder = comparisonObject instanceof ConstantValueExpr.ParamPlaceholder ? (ConstantValueExpr.ParamPlaceholder)comparisonObject : null;
    }

    public Integer getFuzzySlop() {
        return this.fuzzySlop;
    }

    @Override
    public <T> T acceptVisitor(Visitor<?, ?> visitor) {
        return (T)visitor.visit(this);
    }

    @Override
    public ValueExpr getChild() {
        return this.leftChild;
    }

    public String toString() {
        return this.leftChild.toString() + ":'" + this.term + "'" + (String)(this.fuzzySlop != null ? "~" + this.fuzzySlop : "");
    }

    @Override
    public String toQueryString() {
        return this.leftChild.toQueryString() + ":'" + this.term + "'" + (String)(this.fuzzySlop != null ? "~" + this.fuzzySlop : "");
    }

    public String getTerm(Map<String, Object> namedParameters) {
        if (this.paramPlaceholder == null) {
            return this.term;
        }
        String paramName = this.paramPlaceholder.getName();
        if (namedParameters == null) {
            throw new IllegalStateException("Missing value for parameter " + paramName);
        }
        Comparable value = (Comparable)namedParameters.get(paramName);
        if (value == null) {
            throw new IllegalStateException("Missing value for parameter " + paramName);
        }
        if (value instanceof String) {
            return (String)((Object)value);
        }
        throw new IllegalStateException("Parameter must be a string " + paramName);
    }
}

