/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.AbstractCredentialStoreResourceDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.DoohickeyAddHandler;
import org.wildfly.extension.elytron.ElytronDoohickey;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.FileAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.EmptyProvider;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;

final class CredentialStoreResourceDefinition
extends AbstractCredentialStoreResourceDefinition {
    private static final String CS_KEY_STORE_TYPE_ATTRIBUTE = "keyStoreType";
    private static final List<String> filebasedKeystoreTypes = Collections.unmodifiableList(Arrays.asList("JKS", "JCEKS", "PKCS12"));
    static final SimpleAttributeDefinition LOCATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("location", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).setDeprecated(ModelVersion.create((int)13))).setAlternatives(new String[]{"path"})).build();
    static final SimpleAttributeDefinition MODIFIABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("modifiable", ModelType.BOOLEAN, true).setAttributeGroup("implementation")).setDefaultValue(ModelNode.TRUE)).setAllowExpression(false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition CREATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("create", ModelType.BOOLEAN, true).setAttributeGroup("implementation")).setAllowExpression(false)).setDefaultValue(ModelNode.FALSE)).setRestartAllServices()).build();
    static final SimpleMapAttributeDefinition IMPLEMENTATION_PROPERTIES = ((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("implementation-properties", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setRestartAllServices()).build();
    static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = CredentialReference.getAttributeDefinition((boolean)true);
    static final SimpleAttributeDefinition TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROVIDER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider-name", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(true)).setMinSize(1)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("providers", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(false)).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.credential-store")).build();
    static final SimpleAttributeDefinition OTHER_PROVIDERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("other-providers", ModelType.STRING, true).setAttributeGroup("implementation")).setAllowExpression(false)).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.providers", "org.wildfly.security.credential-store")).build();
    static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING, true).setAllowExpression(false)).setMinSize(1)).setAttributeGroup("file")).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, true).setAllowExpression(true)).setMinSize(1)).setAttributeGroup("file")).setRestartAllServices()).setAlternatives(new String[]{"location"})).build();
    private static final StandardResourceDescriptionResolver RESOURCE_RESOLVER = ElytronExtension.getResourceDescriptionResolver("credential-store");
    static final SimpleAttributeDefinition KEY_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-size", ModelType.INT, true).setMinSize(1)).setDefaultValue(new ModelNode(256))).setAllowedValues(new int[]{128, 192, 256})).build();
    static final SimpleAttributeDefinition ADD_ENTRY_TYPE;
    static final SimpleAttributeDefinition REMOVE_ENTRY_TYPE;
    static final SimpleAttributeDefinition SECRET_VALUE;
    private static final SimpleOperationDefinition ADD_ALIAS;
    private static final SimpleOperationDefinition REMOVE_ALIAS;
    private static final SimpleOperationDefinition SET_SECRET;
    private static final SimpleOperationDefinition GENERATE_SECRET_KEY;
    private static final AttributeDefinition[] CONFIG_ATTRIBUTES;
    private static final CredentialStoreAddHandler ADD;
    private static final OperationStepHandler REMOVE;

    CredentialStoreResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"credential-store"), (ResourceDescriptionResolver)RESOURCE_RESOLVER).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveRestartLevel(OperationEntry.Flag.RESTART_NONE).setCapabilities(new RuntimeCapability[]{Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY}));
    }

    @Override
    protected AttributeDefinition[] getAttributeDefinitions() {
        return CONFIG_ATTRIBUTES;
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        boolean isServerOrHostController = ElytronExtension.isServerOrHostController((ImmutableManagementResourceRegistration)resourceRegistration);
        HashMap<String, AbstractCredentialStoreResourceDefinition.CredentialStoreRuntimeOperation> operationMethods = new HashMap<String, AbstractCredentialStoreResourceDefinition.CredentialStoreRuntimeOperation>();
        operationMethods.put("read-aliases", this::readAliasesOperation);
        if (isServerOrHostController) {
            operationMethods.put("add-alias", this::addAliasOperation);
            operationMethods.put("remove-alias", this::removeAliasOperation);
            operationMethods.put("set-secret", this::setSecretOperation);
            operationMethods.put("export-secret-key", this::exportSecretKeyOperation);
            operationMethods.put("generate-secret-key", this::generateSecretKeyOperation);
            operationMethods.put("import-secret-key", this::importSecretKeyOperation);
        }
        AbstractCredentialStoreResourceDefinition.CredentialStoreRuntimeHandler operationHandler = new AbstractCredentialStoreResourceDefinition.CredentialStoreRuntimeHandler(operationMethods);
        resourceRegistration.registerOperationHandler((OperationDefinition)READ_ALIASES, (OperationStepHandler)operationHandler);
        if (isServerOrHostController) {
            resourceRegistration.registerOperationHandler((OperationDefinition)ADD_ALIAS, (OperationStepHandler)operationHandler);
            resourceRegistration.registerOperationHandler((OperationDefinition)REMOVE_ALIAS, (OperationStepHandler)operationHandler);
            resourceRegistration.registerOperationHandler((OperationDefinition)SET_SECRET, (OperationStepHandler)operationHandler);
            resourceRegistration.registerOperationHandler((OperationDefinition)GENERATE_SECRET_KEY, (OperationStepHandler)operationHandler);
            resourceRegistration.registerOperationHandler((OperationDefinition)EXPORT_SECRET_KEY, (OperationStepHandler)operationHandler);
            resourceRegistration.registerOperationHandler((OperationDefinition)IMPORT_SECRET_KEY, (OperationStepHandler)operationHandler);
            resourceRegistration.registerOperationHandler((OperationDefinition)RELOAD, RELOAD_HANDLER);
        }
    }

    void addAliasOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore) throws OperationFailedException {
        try {
            try {
                String alias = ALIAS.resolveModelAttribute(context, operation).asString();
                String entryType = ADD_ENTRY_TYPE.resolveModelAttribute(context, operation).asStringOrNull();
                String secretValue = SECRET_VALUE.resolveModelAttribute(context, operation).asStringOrNull();
                if (entryType == null || entryType.equals(PasswordCredential.class.getCanonicalName())) {
                    if (credentialStore.exists(alias, PasswordCredential.class)) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.credentialAlreadyExists(alias, PasswordCredential.class.getName());
                    }
                } else {
                    String credentialStoreName = CredentialStoreResourceDefinition.credentialStoreName(operation);
                    throw ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreEntryTypeNotSupported(credentialStoreName, entryType);
                }
                CredentialStoreResourceDefinition.storeSecret(credentialStore, alias, secretValue);
            }
            catch (CredentialStoreException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, CredentialStoreResourceDefinition.dumpCause(e));
            }
        }
        catch (RuntimeException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    void removeAliasOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore) throws OperationFailedException {
        String entryType = REMOVE_ENTRY_TYPE.resolveModelAttribute(context, operation).asString();
        Class<? extends Credential> credentialType = CredentialStoreResourceDefinition.fromEntryType(entryType);
        super.removeAliasOperation(context, operation, credentialStore, credentialType);
    }

    void setSecretOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore) throws OperationFailedException {
        try {
            try {
                String alias = ALIAS.resolveModelAttribute(context, operation).asString();
                String entryType = ADD_ENTRY_TYPE.resolveModelAttribute(context, operation).asStringOrNull();
                String secretValue = SECRET_VALUE.resolveModelAttribute(context, operation).asStringOrNull();
                if (entryType == null || entryType.equals(PasswordCredential.class.getCanonicalName())) {
                    if (!credentialStore.exists(alias, PasswordCredential.class)) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.credentialDoesNotExist(alias, PasswordCredential.class.getName());
                    }
                } else {
                    String credentialStoreName = CredentialStoreResourceDefinition.credentialStoreName(operation);
                    throw ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreEntryTypeNotSupported(credentialStoreName, entryType);
                }
                CredentialStoreResourceDefinition.storeSecret(credentialStore, alias, secretValue);
                context.addResponseWarning(Level.WARNING, ElytronSubsystemMessages.ROOT_LOGGER.reloadDependantServices());
            }
            catch (CredentialStoreException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToCompleteOperation(e, CredentialStoreResourceDefinition.dumpCause(e));
            }
        }
        catch (RuntimeException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    protected void generateSecretKeyOperation(OperationContext context, ModelNode operation, CredentialStore credentialStore) throws OperationFailedException {
        int keySize = KEY_SIZE.resolveModelAttribute(context, operation).asInt();
        this.generateSecretKeyOperation(context, operation, credentialStore, keySize);
    }

    static String credentialStoreName(ModelNode operation) {
        String credentialStoreName = null;
        PathAddress pa = PathAddress.pathAddress((ModelNode)operation.require("address"));
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!"credential-store".equals(pe.getKey())) continue;
            credentialStoreName = pe.getValue();
            break;
        }
        if (credentialStoreName == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.operationAddressMissingKey("credential-store");
        }
        return credentialStoreName;
    }

    private static Class<? extends Credential> fromEntryType(String entryTyoe) {
        if (PasswordCredential.class.getCanonicalName().equals(entryTyoe) || PasswordCredential.class.getSimpleName().equals(entryTyoe)) {
            return PasswordCredential.class;
        }
        if (SecretKeyCredential.class.getCanonicalName().equals(entryTyoe) || SecretKeyCredential.class.getSimpleName().equals(entryTyoe)) {
            return SecretKeyCredential.class;
        }
        return null;
    }

    static {
        String[] addEntryTypes = new String[]{PasswordCredential.class.getCanonicalName()};
        ADD_ENTRY_TYPE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("entry-type", ModelType.STRING, true).setAllowedValues(addEntryTypes)).build();
        String[] removeEntryTypes = new String[]{PasswordCredential.class.getCanonicalName(), PasswordCredential.class.getSimpleName(), SecretKeyCredential.class.getCanonicalName(), SecretKeyCredential.class.getSimpleName()};
        REMOVE_ENTRY_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("entry-type", ModelType.STRING, true).setAllowedValues(removeEntryTypes)).setDefaultValue(new ModelNode(PasswordCredential.class.getSimpleName()))).build();
        SECRET_VALUE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secret-value", ModelType.STRING, true).setMinSize(0)).build();
        ADD_ALIAS = new SimpleOperationDefinitionBuilder("add-alias", (ResourceDescriptionResolver)OPERATION_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS, ADD_ENTRY_TYPE, SECRET_VALUE}).setRuntimeOnly().build();
        REMOVE_ALIAS = new SimpleOperationDefinitionBuilder("remove-alias", (ResourceDescriptionResolver)OPERATION_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS, REMOVE_ENTRY_TYPE}).setRuntimeOnly().build();
        SET_SECRET = new SimpleOperationDefinitionBuilder("set-secret", (ResourceDescriptionResolver)OPERATION_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS, ADD_ENTRY_TYPE, SECRET_VALUE}).setRuntimeOnly().build();
        GENERATE_SECRET_KEY = new SimpleOperationDefinitionBuilder("generate-secret-key", (ResourceDescriptionResolver)OPERATION_RESOLVER).setParameters(new AttributeDefinition[]{ALIAS, KEY_SIZE}).setRuntimeOnly().build();
        CONFIG_ATTRIBUTES = new AttributeDefinition[]{LOCATION, PATH, CREATE, MODIFIABLE, IMPLEMENTATION_PROPERTIES, CREDENTIAL_REFERENCE, TYPE, PROVIDER_NAME, PROVIDERS, OTHER_PROVIDERS, RELATIVE_TO};
        ADD = new CredentialStoreAddHandler();
        REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY);
    }

    static class CredentialStoreDoohickey
    extends AbstractCredentialStoreResourceDefinition.AbstractCredentialStoreDoohickey {
        private final String name;
        private volatile String location;
        private volatile boolean modifiable;
        private volatile String type;
        private volatile String providers;
        private volatile String otherProviders;
        private volatile String providerName;
        private volatile String relativeTo;
        private volatile Map<String, String> credentialStoreAttributes;
        private volatile ModelNode model;
        private volatile ExceptionRunnable<GeneralSecurityException> reloader;

        protected CredentialStoreDoohickey(PathAddress resourceAddress) {
            super(resourceAddress);
            this.name = resourceAddress.getLastElement().getValue();
        }

        @Override
        protected void resolveRuntime(ModelNode model, OperationContext context) throws OperationFailedException {
            this.location = PATH.resolveModelAttribute(context, model).asStringOrNull();
            if (this.location == null) {
                this.location = LOCATION.resolveModelAttribute(context, model).asStringOrNull();
            }
            this.credentialStoreAttributes = new HashMap<String, String>();
            this.modifiable = MODIFIABLE.resolveModelAttribute(context, model).asBoolean();
            this.credentialStoreAttributes.put("modifiable", Boolean.toString(this.modifiable));
            boolean create = CREATE.resolveModelAttribute(context, model).asBoolean();
            this.credentialStoreAttributes.put("create", Boolean.toString(create));
            ModelNode implAttrModel = IMPLEMENTATION_PROPERTIES.resolveModelAttribute(context, model);
            if (implAttrModel.isDefined()) {
                for (String s : implAttrModel.keys()) {
                    this.credentialStoreAttributes.put(s, implAttrModel.require(s).asString());
                }
            }
            this.type = TYPE.resolveModelAttribute(context, model).asStringOrNull();
            this.providers = PROVIDERS.resolveModelAttribute(context, model).asStringOrNull();
            this.otherProviders = OTHER_PROVIDERS.resolveModelAttribute(context, model).asStringOrNull();
            this.providerName = PROVIDER_NAME.resolveModelAttribute(context, model).asStringOrNull();
            this.relativeTo = RELATIVE_TO.resolveModelAttribute(context, model).asStringOrNull();
            if (this.type == null || this.type.equals(KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE)) {
                this.credentialStoreAttributes.putIfAbsent(CredentialStoreResourceDefinition.CS_KEY_STORE_TYPE_ATTRIBUTE, "JCEKS");
            }
            String implAttrKeyStoreType = this.credentialStoreAttributes.get(CredentialStoreResourceDefinition.CS_KEY_STORE_TYPE_ATTRIBUTE);
            if (this.location == null && implAttrKeyStoreType != null && filebasedKeystoreTypes.contains(implAttrKeyStoreType.toUpperCase(Locale.ENGLISH))) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.filebasedKeystoreLocationMissing(implAttrKeyStoreType);
            }
            this.model = model;
        }

        @Override
        protected ExceptionSupplier<CredentialStore, StartException> prepareServiceSupplier(OperationContext context, CapabilityServiceBuilder<?> serviceBuilder) throws OperationFailedException {
            Supplier otherProviderSupplier;
            Supplier providerSupplier;
            Supplier pathManager;
            if (this.relativeTo != null) {
                pathManager = serviceBuilder.requires(PathManagerService.SERVICE_NAME);
                serviceBuilder.requires(FileAttributeDefinitions.pathName(this.relativeTo));
            } else {
                pathManager = null;
            }
            if (this.providers != null) {
                String providersCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)this.providers);
                ServiceName providerLoaderServiceName = context.getCapabilityServiceName(providersCapabilityName, Provider[].class);
                providerSupplier = serviceBuilder.requires(providerLoaderServiceName);
            } else {
                providerSupplier = null;
            }
            if (this.otherProviders != null) {
                String providersCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.providers", (String)this.otherProviders);
                ServiceName otherProvidersLoaderServiceName = context.getCapabilityServiceName(providersCapabilityName, Provider[].class);
                otherProviderSupplier = serviceBuilder.requires(otherProvidersLoaderServiceName);
            } else {
                otherProviderSupplier = null;
            }
            final ExceptionSupplier credentialSourceSupplier = CredentialReference.getCredentialSourceSupplier((OperationContext)context, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)this.model, serviceBuilder);
            return new ExceptionSupplier<CredentialStore, StartException>(){

                public CredentialStore get() throws StartException {
                    try {
                        Object[] otherProvidersArr;
                        if (location != null) {
                            FileAttributeDefinitions.PathResolver pathResolver = FileAttributeDefinitions.pathResolver();
                            pathResolver.path(location);
                            if (relativeTo != null) {
                                pathResolver.relativeTo(relativeTo, (PathManager)pathManager.get());
                            }
                            File resolved = pathResolver.resolve();
                            pathResolver.clear();
                            credentialStoreAttributes.put("location", resolved.getAbsolutePath());
                        } else {
                            credentialStoreAttributes.put("location", null);
                        }
                        ElytronSubsystemMessages.ROOT_LOGGER.tracef("starting CredentialStore:  name = %s", name);
                        final CredentialStore cs = this.getCredentialStoreInstance(providerSupplier != null ? (Provider[])providerSupplier.get() : null);
                        Object[] objectArray = otherProvidersArr = otherProviderSupplier != null ? (Provider[])otherProviderSupplier.get() : null;
                        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                            ElytronSubsystemMessages.ROOT_LOGGER.tracef("initializing CredentialStore:  name = %s  type = %s  provider = %s  otherProviders = %s  attributes = %s", new Object[]{name, type, providerName, Arrays.toString(otherProvidersArr), credentialStoreAttributes});
                        }
                        final CredentialStore.CredentialSourceProtectionParameter credentialSource = CredentialStoreDoohickey.resolveCredentialStoreProtectionParameter(name, credentialSourceSupplier != null ? (CredentialSource)credentialSourceSupplier.get() : null);
                        reloader = new ExceptionRunnable<GeneralSecurityException>((Provider[])otherProvidersArr){
                            final /* synthetic */ Provider[] val$otherProvidersArr;
                            {
                                this.val$otherProvidersArr = providerArray;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() throws GeneralSecurityException {
                                EmptyProvider emptyProvider = EmptyProvider.getInstance();
                                synchronized (emptyProvider) {
                                    cs.initialize(credentialStoreAttributes, (CredentialStore.ProtectionParameter)credentialSource, this.val$otherProvidersArr);
                                }
                            }
                        };
                        reloader.run();
                        return cs;
                    }
                    catch (Exception e) {
                        throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
                    }
                }
            };
        }

        @Override
        protected CredentialStore createImmediately(OperationContext foreignContext) throws OperationFailedException {
            Provider[] otherProviders;
            File resolvedPath = null;
            if (this.location != null) {
                resolvedPath = this.resolveRelativeToImmediately(this.location, this.relativeTo, foreignContext);
                this.credentialStoreAttributes.put("location", resolvedPath.getAbsolutePath());
            }
            Provider[] providers = null;
            if (this.providers != null) {
                ExceptionFunction providerApi = (ExceptionFunction)foreignContext.getCapabilityRuntimeAPI("org.wildfly.security.providers-api", this.providers, ExceptionFunction.class);
                providers = (Provider[])providerApi.apply((Object)foreignContext);
            }
            if (this.otherProviders != null) {
                ExceptionFunction providerApi = (ExceptionFunction)foreignContext.getCapabilityRuntimeAPI("org.wildfly.security.providers-api", this.otherProviders, ExceptionFunction.class);
                otherProviders = (Provider[])providerApi.apply((Object)foreignContext);
            } else {
                otherProviders = null;
            }
            CredentialSource credentialSource = CredentialReference.getCredentialSource((OperationContext)foreignContext, (ObjectTypeAttributeDefinition)CREDENTIAL_REFERENCE, (ModelNode)this.model);
            try {
                final CredentialStore credentialStore = this.getCredentialStoreInstance(providers);
                final CredentialStore.CredentialSourceProtectionParameter protectionParamter = CredentialStoreDoohickey.resolveCredentialStoreProtectionParameter(this.name, credentialSource);
                this.reloader = new ExceptionRunnable<GeneralSecurityException>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws GeneralSecurityException {
                        EmptyProvider emptyProvider = EmptyProvider.getInstance();
                        synchronized (emptyProvider) {
                            credentialStore.initialize(credentialStoreAttributes, (CredentialStore.ProtectionParameter)protectionParamter, otherProviders);
                        }
                    }
                };
                this.reloader.run();
                return credentialStore;
            }
            catch (IOException | GeneralSecurityException e) {
                throw ElytronSubsystemMessages.ROOT_LOGGER.unableToInitialiseCredentialStore(e);
            }
        }

        @Override
        protected void reload(OperationContext context) throws GeneralSecurityException, OperationFailedException {
            if (this.reloader != null) {
                this.reloader.run();
            } else {
                super.apply(context);
            }
        }

        private CredentialStore getCredentialStoreInstance(Provider[] injectedProviders) throws CredentialStoreException, NoSuchAlgorithmException, NoSuchProviderException {
            String resolvedType;
            String string = resolvedType = this.type != null ? this.type : KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE;
            if (this.providerName != null) {
                return CredentialStore.getInstance((String)resolvedType, (String)this.providerName);
            }
            if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                ElytronSubsystemMessages.ROOT_LOGGER.tracef("obtaining CredentialStore %s from providers %s", this.name, Arrays.toString(injectedProviders));
            }
            if (injectedProviders != null) {
                for (Provider p : injectedProviders) {
                    try {
                        return CredentialStore.getInstance((String)resolvedType, (Provider)p);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    }
                }
                throw ElytronSubsystemMessages.ROOT_LOGGER.providerLoaderCannotSupplyProvider(this.providers, resolvedType);
            }
            return CredentialStore.getInstance((String)resolvedType);
        }

        private static CredentialStore.CredentialSourceProtectionParameter resolveCredentialStoreProtectionParameter(String name, CredentialSource cs) throws IOException {
            if (cs != null) {
                Credential credential = cs.getCredential(PasswordCredential.class);
                ElytronSubsystemMessages.ROOT_LOGGER.tracef("resolving CredentialStore %s ProtectionParameter from %s", name, credential);
                return CredentialStoreDoohickey.credentialToCredentialSourceProtectionParameter(credential);
            }
            throw ElytronSubsystemMessages.ROOT_LOGGER.credentialStoreProtectionParameterCannotBeResolved(name);
        }

        private static CredentialStore.CredentialSourceProtectionParameter credentialToCredentialSourceProtectionParameter(Credential credential) {
            return new CredentialStore.CredentialSourceProtectionParameter((CredentialSource)IdentityCredentials.NONE.withCredential(credential));
        }
    }

    private static class CredentialStoreAddHandler
    extends DoohickeyAddHandler<CredentialStore> {
        private CredentialStoreAddHandler() {
            super(Capabilities.CREDENTIAL_STORE_RUNTIME_CAPABILITY, CONFIG_ATTRIBUTES, "org.wildfly.security.credential-store-api");
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            CredentialReference.handleCredentialReferenceUpdate((OperationContext)context, (ModelNode)resource.getModel());
        }

        @Override
        protected ElytronDoohickey<CredentialStore> createDoohickey(PathAddress resourceAddress) {
            return new CredentialStoreDoohickey(resourceAddress);
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            CredentialReference.rollbackCredentialStoreUpdate((AttributeDefinition)CREDENTIAL_REFERENCE, (OperationContext)context, (Resource)resource);
        }
    }
}

