/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceDefinitionProvider;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAttribute;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.LongRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolFactoryServiceConfigurator;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum ThreadPoolResourceDefinition implements ResourceDefinitionProvider,
ThreadPoolDefinition,
ResourceServiceConfiguratorFactory
{
    DEFAULT("default", 0, 200, 0, 60000L);

    static final PathElement WILDCARD_PATH;
    private final PathElement path;
    private final Attribute minThreads;
    private final Attribute maxThreads;
    private final Attribute keepAliveTime;

    private static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"thread-pool", (String)name);
    }

    private ThreadPoolResourceDefinition(String name, int defaultMinThreads, int defaultMaxThreads, int defaultQueueLength, long defaultKeepAliveTime) {
        this.path = ThreadPoolResourceDefinition.pathElement(name);
        this.minThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("min-threads", ModelType.INT, new ModelNode(defaultMinThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.maxThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("max-threads", ModelType.INT, new ModelNode(defaultMaxThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.keepAliveTime = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("keepalive-time", ModelType.LONG, new ModelNode(defaultKeepAliveTime), (ParameterValidatorBuilder)new LongRangeValidatorBuilder().min(0L)).build());
    }

    private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validatorBuilder) {
        SimpleAttributeDefinitionBuilder builder = (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null));
        return (SimpleAttributeDefinitionBuilder)builder.setValidator(validatorBuilder.configure((AbstractAttributeDefinitionBuilder)builder).build());
    }

    public void register(ManagementResourceRegistration parentRegistration) {
        ParentResourceDescriptionResolver resolver = JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(this.path, ThreadPoolResourceDefinition.pathElement("*"));
        SimpleResourceDefinition.Parameters parameters = new SimpleResourceDefinition.Parameters(this.path, (ResourceDescriptionResolver)resolver);
        SimpleResourceDefinition definition = new SimpleResourceDefinition(parameters);
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)definition);
        ResourceDescriptor descriptor = new ResourceDescriptor((ResourceDescriptionResolver)resolver).addAttributes(new Attribute[]{this.minThreads, this.maxThreads, this.keepAliveTime});
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceConfiguratorFactory)this);
        new SimpleResourceRegistrar(descriptor, (ResourceServiceHandler)handler).register(registration);
    }

    public ResourceServiceConfigurator createServiceConfigurator(PathAddress address) {
        return new ThreadPoolFactoryServiceConfigurator(this, address);
    }

    Collection<Attribute> getAttributes() {
        return Arrays.asList(this.minThreads, this.maxThreads, this.keepAliveTime);
    }

    @Override
    public Attribute getMinThreads() {
        return this.minThreads;
    }

    @Override
    public Attribute getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public Attribute getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public PathElement getPathElement() {
        return this.path;
    }

    static {
        WILDCARD_PATH = ThreadPoolResourceDefinition.pathElement("*");
    }
}

