/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.docvalues.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.DoubleMultiValuesToSingleValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.GeoPointDistanceDocValues;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.NumericDoubleValues;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.engine.spatial.GeoPoint;

public class GeoPointDistanceMultiValuesToSingleValuesSource
extends DoubleMultiValuesToSingleValuesSource {
    private final String field;
    private final GeoPoint center;

    public GeoPointDistanceMultiValuesToSingleValuesSource(String field, MultiValueMode mode, NestedDocsProvider nestedDocsProvider, GeoPoint center) {
        super(mode, nestedDocsProvider);
        this.field = field;
        this.center = center;
    }

    public String toString() {
        return "distance(" + this.field + "," + this.center + "," + this.mode + "," + this.nestedDocsProvider + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointDistanceMultiValuesToSingleValuesSource that = (GeoPointDistanceMultiValuesToSingleValuesSource)((Object)o);
        return Objects.equals(this.field, that.field) && Objects.equals(this.center, that.center);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.field, this.center);
    }

    public boolean needsScores() {
        return false;
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{this.field});
    }

    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        NumericDoubleValues values = this.getValues(ctx, null);
        if (values.advanceExact(docId)) {
            return Explanation.match((Number)values.doubleValue(), (String)this.toString(), (Explanation[])new Explanation[0]);
        }
        return Explanation.noMatch((String)this.toString(), (Explanation[])new Explanation[0]);
    }

    public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
        return this;
    }

    @Override
    protected GeoPointDistanceDocValues getSortedNumericDoubleDocValues(LeafReaderContext ctx) throws IOException {
        return new GeoPointDistanceDocValues(DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)this.field), this.center);
    }
}

