/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

public interface InfiniteOrPositiveValidators {
    public static final ModelTypeValidator LONG_INSTANCE = new ModelTypeValidator(ModelType.LONG){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            long val = value.asLong();
            if (val > -1L && (val <= 0L || val >= Long.MAX_VALUE)) {
                throw new OperationFailedException(MessagingLogger.ROOT_LOGGER.illegalValue(value, parameterName));
            }
        }
    };
    public static final ModelTypeValidator INT_INSTANCE = new ModelTypeValidator(ModelType.INT){

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            int val = value.asInt();
            if (val > -1 && (val <= 0 || val >= Integer.MAX_VALUE)) {
                throw new OperationFailedException(MessagingLogger.ROOT_LOGGER.illegalValue(value, parameterName));
            }
        }
    };
    public static final ParameterCorrector NEGATIVE_VALUE_CORRECTOR = new ParameterCorrector(){

        public ModelNode correct(ModelNode newValue, ModelNode currentValue) {
            if (newValue.isDefined() && newValue.getType() != ModelType.EXPRESSION) {
                try {
                    if (newValue.asLong() < -1L) {
                        return new ModelNode(-1);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return newValue;
        }
    };
}

