/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;

class ConnectionFactoryService
implements Service<Void> {
    private final String name;
    private final ConnectionFactoryConfiguration configuration;
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();

    public ConnectionFactoryService(ConnectionFactoryConfiguration configuration) {
        this.name = configuration.getName();
        if (this.name == null) {
            throw MessagingLogger.ROOT_LOGGER.nullVar("cf name");
        }
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(final StartContext context) throws StartException {
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.createConnectionFactory(false, ConnectionFactoryService.this.configuration, ConnectionFactoryService.this.configuration.getBindings());
                    context.complete();
                }
                catch (Throwable e) {
                    context.failed(MessagingLogger.ROOT_LOGGER.failedToCreate(e, "connection-factory"));
                }
            }
        };
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext context) {
        final JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    jmsManager.destroyConnectionFactory(ConnectionFactoryService.this.name);
                }
                catch (Throwable e) {
                    MessagingLogger.ROOT_LOGGER.failedToDestroy("connection-factory", ConnectionFactoryService.this.name);
                }
                context.complete();
            }
        };
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    InjectedValue<JMSServerManager> getJmsServer() {
        return this.jmsServer;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executorInjector;
    }
}

