/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.AbstractOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.GenericOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.InsecureOutboundConnection;
import org.jboss.as.remoting.RemotingSubsystemRootResource;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.remoting3.Endpoint;

class GenericOutboundConnectionAdd
extends AbstractAddStepHandler {
    GenericOutboundConnectionAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)resource);
        GenericOutboundConnectionAdd.installRuntimeService(context, fullModel);
    }

    static void installRuntimeService(OperationContext context, ModelNode fullModel) throws OperationFailedException {
        URI uri = GenericOutboundConnectionAdd.getDestinationURI(context, fullModel);
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(AbstractOutboundConnectionResourceDefinition.OUTBOUND_CONNECTION_CAPABILITY);
        Consumer injector = builder.provides(AbstractOutboundConnectionResourceDefinition.OUTBOUND_CONNECTION_CAPABILITY);
        builder.setInstance(Service.newInstance((Consumer)injector, (Object)new InsecureOutboundConnection(uri)));
        builder.requiresCapability(RemotingSubsystemRootResource.REMOTING_ENDPOINT_CAPABILITY.getName(), Endpoint.class, new String[0]);
        builder.install();
    }

    static URI getDestinationURI(OperationContext context, ModelNode outboundConnection) throws OperationFailedException {
        String uri = GenericOutboundConnectionResourceDefinition.URI.resolveModelAttribute(context, outboundConnection).asString();
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotCreateURI(uri, e.toString());
        }
    }
}

