/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource;

import java.util.function.UnaryOperator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;

public interface AttributeTranslation {
    public AttributeDefinition getTargetAttribute();

    public AttributeValueTranslator getReadAttributeOperationTranslator();

    public AttributeValueTranslator getWriteAttributeOperationTranslator();

    default public UnaryOperator<PathAddress> getPathAddressTranslator() {
        return UnaryOperator.identity();
    }

    public static AttributeTranslation alias(AttributeDefinition targetAttribute) {
        return AttributeTranslation.relocate(targetAttribute, UnaryOperator.identity());
    }

    public static AttributeTranslation relocate(final AttributeDefinition targetAttribute, final UnaryOperator<PathAddress> addressTranslator) {
        return new AttributeTranslation(){

            @Override
            public AttributeDefinition getTargetAttribute() {
                return targetAttribute;
            }

            @Override
            public UnaryOperator<PathAddress> getPathAddressTranslator() {
                return addressTranslator;
            }

            @Override
            public AttributeValueTranslator getReadAttributeOperationTranslator() {
                return AttributeValueTranslator.IDENTITY;
            }

            @Override
            public AttributeValueTranslator getWriteAttributeOperationTranslator() {
                return AttributeValueTranslator.IDENTITY;
            }
        };
    }

    public static AttributeTranslation singletonList(final AttributeDefinition targetAttribute) {
        return new AttributeTranslation(){

            @Override
            public AttributeDefinition getTargetAttribute() {
                return targetAttribute;
            }

            @Override
            public AttributeValueTranslator getReadAttributeOperationTranslator() {
                return new AttributeValueTranslator(){

                    @Override
                    public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
                        return value.isDefined() ? (ModelNode)value.asList().get(0) : value;
                    }
                };
            }

            @Override
            public AttributeValueTranslator getWriteAttributeOperationTranslator() {
                return new AttributeValueTranslator(){

                    @Override
                    public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
                        return new ModelNode().add(value);
                    }
                };
            }
        };
    }

    public static interface AttributeValueTranslator {
        public static final AttributeValueTranslator IDENTITY = new AttributeValueTranslator(){

            @Override
            public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
                return value;
            }
        };

        public ModelNode translate(OperationContext var1, ModelNode var2) throws OperationFailedException;
    }
}

