/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.security.DataExpiredException;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import net.shibboleth.utilities.java.support.security.KeyNotFoundException;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSealer
extends AbstractInitializableComponent {
    private static final int CHUNK_SIZE = 60000;
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DataSealer.class);
    private boolean lockedAtStartup;
    @NonnullAfterInit
    private DataSealerKeyStrategy keyStrategy;
    @NonnullAfterInit
    private SecureRandom random;
    @Nonnull
    private BinaryEncoder encoder = new Base64(0, new byte[]{10});
    @Nonnull
    private BinaryDecoder decoder = (Base64)this.encoder;

    public void setLockedAtStartup(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.lockedAtStartup = flag;
    }

    public void setKeyStrategy(@Nonnull DataSealerKeyStrategy strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.keyStrategy = Constraint.isNotNull(strategy, "DataSealerKeyStrategy cannot be null");
    }

    public void setRandom(@Nonnull SecureRandom r) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.random = Constraint.isNotNull(r, "SecureRandom cannot be null");
    }

    public void setEncoder(@Nonnull BinaryEncoder e) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.encoder = Constraint.isNotNull(e, "Encoder cannot be null");
    }

    public void setDecoder(@Nonnull BinaryDecoder d) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.decoder = Constraint.isNotNull(d, "Decoder cannot be null");
    }

    @Override
    public void doInitialize() throws ComponentInitializationException {
        try {
            try {
                Constraint.isNotNull(this.keyStrategy, "DataSealerKeyStrategy cannot be null");
            }
            catch (ConstraintViolationException e) {
                throw new ComponentInitializationException(e);
            }
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            if (!this.lockedAtStartup) {
                this.testEncryption(this.keyStrategy.getDefaultKey().getSecond());
            }
        }
        catch (KeyException e) {
            this.log.error(e.getMessage());
            throw new ComponentInitializationException("Exception loading the keystore", e);
        }
        catch (DataSealerException e) {
            this.log.error(e.getMessage());
            throw new ComponentInitializationException("Exception testing the encryption settings used", e);
        }
    }

    @Nonnull
    public String unwrap(@Nonnull @NotEmpty String wrapped) throws DataSealerException {
        return this.unwrap(wrapped, null);
    }

    @Nonnull
    public String unwrap(@Nonnull @NotEmpty String wrapped, @Nullable StringBuffer keyUsed) throws DataSealerException {
        String string;
        byte[] in = this.decoder.decode(wrapped.getBytes(StandardCharsets.UTF_8));
        DataInputStream inputDataStream = new DataInputStream(new ByteArrayInputStream(in));
        try {
            String keyAlias = inputDataStream.readUTF();
            this.log.trace("Data was encrypted by key named '{}'", (Object)keyAlias);
            if (keyUsed != null) {
                keyUsed.append(keyAlias);
            }
            SecretKey key = this.keyStrategy.getKey(keyAlias);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            int ivSize = cipher.getBlockSize();
            byte[] iv = new byte[ivSize];
            inputDataStream.readFully(iv);
            GCMParameterSpec params = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)key, params);
            cipher.updateAAD(keyAlias.getBytes());
            byte[] data = new byte[in.length - ivSize];
            int dataSize = inputDataStream.read(data);
            byte[] plaintext = new byte[cipher.getOutputSize(dataSize)];
            int outputLen = cipher.update(data, 0, dataSize, plaintext, 0);
            cipher.doFinal(plaintext, outputLen);
            string = this.extractAndCheckDecryptedData(plaintext);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputDataStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (KeyNotFoundException e) {
                if (keyUsed != null) {
                    this.log.info("Data was wrapped with a key ({}) no longer available", (Object)keyUsed.toString());
                } else {
                    this.log.info("Data was wrapped with a key no longer available");
                }
                throw new DataExpiredException("Data wrapped with expired key");
            }
            catch (KeyException e) {
                this.log.error(e.getMessage());
                throw new DataSealerException("Exception loading key", e);
            }
            catch (IOException | IllegalArgumentException | GeneralSecurityException | DecoderException e) {
                this.log.error("Exception unwrapping data: {}", (Object)e.getMessage());
                throw new DataSealerException("Exception unwrapping data", (Exception)e);
            }
        }
        inputDataStream.close();
        return string;
    }

    @Nonnull
    private String extractAndCheckDecryptedData(@Nonnull @NotEmpty byte[] decryptedBytes) throws DataSealerException {
        DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(decryptedBytes)));
        try {
            long decodedExpirationTime = dataInputStream.readLong();
            if (System.currentTimeMillis() > decodedExpirationTime) {
                this.log.debug("Unwrapped data has expired");
                throw new DataExpiredException("Unwrapped data has expired");
            }
            StringBuffer accumulator = new StringBuffer();
            int count = 0;
            try {
                while (true) {
                    String decodedData = dataInputStream.readUTF();
                    accumulator.append(decodedData);
                    this.log.trace("Read chunk #{} from output stream", (Object)(++count));
                }
            }
            catch (EOFException e) {
                this.log.trace("Unwrapped data verified");
                String string = accumulator.toString();
                dataInputStream.close();
                return string;
            }
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.log.error(e.getMessage());
                throw new DataSealerException("Caught IOException unwrapping data", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public String wrap(@Nonnull @NotEmpty String data, @Nonnull Instant exp) throws DataSealerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void testEncryption(@Nullable SecretKey key) throws DataSealerException {
        String decrypted;
        if (key == null) {
            throw new DataSealerException("Secret key was null");
        }
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            byte[] iv = new byte[cipher.getBlockSize()];
            this.random.nextBytes(iv);
            GCMParameterSpec params = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)key, params);
            cipher.updateAAD("aad".getBytes(StandardCharsets.UTF_8));
            byte[] plaintext = "test".getBytes(StandardCharsets.UTF_8);
            byte[] encryptedData = new byte[cipher.getOutputSize(plaintext.length)];
            int outputLen = cipher.update(plaintext, 0, plaintext.length, encryptedData, 0);
            cipher.doFinal(encryptedData, outputLen);
            cipher.init(2, (Key)key, params);
            cipher.updateAAD("aad".getBytes(StandardCharsets.UTF_8));
            plaintext = new byte[cipher.getOutputSize(encryptedData.length)];
            outputLen = cipher.update(encryptedData, 0, encryptedData.length, plaintext, 0);
            cipher.doFinal(plaintext, outputLen);
            decrypted = new String(plaintext, StandardCharsets.UTF_8);
        }
        catch (IllegalStateException | GeneralSecurityException e) {
            this.log.error("Round trip encryption/decryption test unsuccessful: {}", (Object)e.getMessage());
            throw new DataSealerException("Round trip encryption/decryption test unsuccessful", e);
        }
        if (decrypted == null || !"test".equals(decrypted)) {
            this.log.error("Round trip encryption/decryption test unsuccessful. Decrypted text did not match");
            throw new DataSealerException("Round trip encryption/decryption test unsuccessful");
        }
    }
}

